"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var GeometryDebuggingView_exports = {};
__export(GeometryDebuggingView_exports, {
  GeometryDebuggingView: () => GeometryDebuggingView
});
module.exports = __toCommonJS(GeometryDebuggingView_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_state_react = require("@tldraw/state-react");
var import_utils = require("@tldraw/utils");
var import_react = require("react");
var import_useEditor = require("../hooks/useEditor");
var import_Group2d = require("../primitives/geometry/Group2d");
function useTick(isEnabled = true) {
  const [_, setTick] = (0, import_react.useState)(0);
  const editor = (0, import_useEditor.useEditor)();
  (0, import_react.useEffect)(() => {
    if (!isEnabled) return;
    const update = () => setTick((tick) => tick + 1);
    editor.on("tick", update);
    return () => {
      editor.off("tick", update);
    };
  }, [editor, isEnabled]);
}
const GeometryDebuggingView = (0, import_state_react.track)(function GeometryDebuggingView2({
  showStroke = true,
  showVertices = true,
  showClosestPointOnOutline = true
}) {
  const editor = (0, import_useEditor.useEditor)();
  useTick(showClosestPointOnOutline);
  const zoomLevel = editor.getZoomLevel();
  const renderingShapes = editor.getRenderingShapes();
  const {
    inputs: { currentPagePoint }
  } = editor;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    "svg",
    {
      style: {
        position: "absolute",
        pointerEvents: "none",
        zIndex: 999999999,
        top: 0,
        left: 0,
        overflow: "visible"
      },
      children: renderingShapes.map((result) => {
        const shape = editor.getShape(result.id);
        if (shape.type === "group") return null;
        const geometry = editor.getShapeGeometry(shape);
        const pageTransform = editor.getShapePageTransform(shape);
        const pointInShapeSpace = editor.getPointInShapeSpace(shape, currentPagePoint);
        const nearestPointOnShape = geometry.nearestPoint(pointInShapeSpace);
        const distanceToPoint = geometry.distanceToPoint(pointInShapeSpace, true);
        const dist = Math.abs(distanceToPoint) * zoomLevel;
        const hitInside = distanceToPoint < 0;
        const { vertices } = geometry;
        return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
          "g",
          {
            transform: pageTransform.toCssString(),
            strokeLinecap: "round",
            strokeLinejoin: "round",
            children: [
              showStroke && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
                "g",
                {
                  stroke: geometry.debugColor ?? "red",
                  opacity: "1",
                  strokeWidth: 2 / zoomLevel,
                  fill: "none",
                  children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(GeometryStroke, { geometry })
                }
              ),
              showVertices && vertices.map((v, i) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
                "circle",
                {
                  cx: v.x,
                  cy: v.y,
                  r: 2 / zoomLevel,
                  fill: `hsl(${(0, import_utils.modulate)(i, [0, vertices.length - 1], [120, 200])}, 100%, 50%)`,
                  stroke: "black",
                  strokeWidth: 1 / zoomLevel
                },
                `v${i}`
              )),
              showClosestPointOnOutline && dist < 150 && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
                "line",
                {
                  x1: nearestPointOnShape.x,
                  y1: nearestPointOnShape.y,
                  x2: pointInShapeSpace.x,
                  y2: pointInShapeSpace.y,
                  opacity: 1 - dist / 150,
                  stroke: hitInside ? "goldenrod" : "dodgerblue",
                  strokeWidth: 2 / zoomLevel
                }
              )
            ]
          },
          result.id + "_outline"
        );
      })
    }
  );
});
function GeometryStroke({ geometry }) {
  if (geometry instanceof import_Group2d.Group2d) {
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_jsx_runtime.Fragment, { children: [...geometry.children, ...geometry.ignoredChildren].map((child, i) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(GeometryStroke, { geometry: child }, i)) });
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("path", { d: geometry.toSimpleSvgPath() });
}
//# sourceMappingURL=GeometryDebuggingView.js.map
