"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DefaultHandle_exports = {};
__export(DefaultHandle_exports, {
  DefaultHandle: () => DefaultHandle
});
module.exports = __toCommonJS(DefaultHandle_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_classnames = __toESM(require("classnames"));
var import_constants = require("../../constants");
var import_useEditor = require("../../hooks/useEditor");
function DefaultHandle({ handle, isCoarse, className, zoom }) {
  const editor = (0, import_useEditor.useEditor)();
  const br = (isCoarse ? editor.options.coarseHandleRadius : editor.options.handleRadius) / zoom;
  if (handle.type === "clone") {
    const fr2 = 3 / zoom;
    const path = `M0,${-fr2} A${fr2},${fr2} 0 0,1 0,${fr2}`;
    const index = import_constants.SIDES.indexOf(handle.id);
    return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("g", { className: (0, import_classnames.default)(`tl-handle tl-handle__${handle.type}`, className), children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)("circle", { className: "tl-handle__bg", r: br }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)("path", { className: "tl-handle__fg", d: path, transform: `rotate(${-90 + 90 * index})` })
    ] });
  }
  const fr = (handle.type === "create" && isCoarse ? 3 : 4) / Math.max(zoom, 0.25);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("g", { className: (0, import_classnames.default)(`tl-handle tl-handle__${handle.type}`, className), children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("circle", { className: "tl-handle__bg", r: br }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("circle", { className: "tl-handle__fg", r: fr })
  ] });
}
//# sourceMappingURL=DefaultHandle.js.map
