"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var notVisibleShapes_exports = {};
__export(notVisibleShapes_exports, {
  notVisibleShapes: () => notVisibleShapes
});
module.exports = __toCommonJS(notVisibleShapes_exports);
var import_state = require("@tldraw/state");
function isShapeNotVisible(editor, id, viewportPageBounds) {
  const maskedPageBounds = editor.getShapeMaskedPageBounds(id);
  if (maskedPageBounds === void 0) return true;
  return !viewportPageBounds.includes(maskedPageBounds);
}
const notVisibleShapes = (editor) => {
  function fromScratch(editor2) {
    const shapes = editor2.getCurrentPageShapeIds();
    const viewportPageBounds = editor2.getViewportPageBounds();
    const notVisibleShapes2 = /* @__PURE__ */ new Set();
    shapes.forEach((id) => {
      if (isShapeNotVisible(editor2, id, viewportPageBounds)) {
        notVisibleShapes2.add(id);
      }
    });
    return notVisibleShapes2;
  }
  return (0, import_state.computed)("getCulledShapes", (prevValue) => {
    if ((0, import_state.isUninitialized)(prevValue)) {
      return fromScratch(editor);
    }
    const nextValue = fromScratch(editor);
    if (prevValue.size !== nextValue.size) return nextValue;
    for (const prev of prevValue) {
      if (!nextValue.has(prev)) {
        return nextValue;
      }
    }
    return prevValue;
  });
};
//# sourceMappingURL=notVisibleShapes.js.map
