"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var FocusManager_exports = {};
__export(FocusManager_exports, {
  FocusManager: () => FocusManager
});
module.exports = __toCommonJS(FocusManager_exports);
class FocusManager {
  constructor(editor, autoFocus) {
    this.editor = editor;
    this.disposeSideEffectListener = editor.sideEffects.registerAfterChangeHandler(
      "instance",
      (prev, next) => {
        if (prev.isFocused !== next.isFocused) {
          next.isFocused ? this.focus() : this.blur();
          this.updateContainerClass();
        }
      }
    );
    const currentFocusState = editor.getInstanceState().isFocused;
    if (autoFocus !== currentFocusState) {
      editor.updateInstanceState({ isFocused: !!autoFocus });
    }
    this.updateContainerClass();
  }
  disposeSideEffectListener;
  /**
   * The editor's focus state and the container's focus state
   * are not necessarily always in sync. For that reason we
   * can't rely on the css `:focus` or `:focus-within` selectors to style the
   * editor when it is in focus.
   *
   * For that reason we synchronize the editor's focus state with a
   * special class on the container: tl-container__focused
   */
  updateContainerClass() {
    const container = this.editor.getContainer();
    const instanceState = this.editor.getInstanceState();
    if (instanceState.isFocused) {
      container.classList.add("tl-container__focused");
    } else {
      container.classList.remove("tl-container__focused");
    }
  }
  focus() {
    this.editor.getContainer().focus();
  }
  blur() {
    this.editor.complete();
    this.editor.getContainer().blur();
  }
  dispose() {
    this.disposeSideEffectListener?.();
  }
}
//# sourceMappingURL=FocusManager.js.map
