"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp(target, key, result);
  return result;
};
var SnapManager_exports = {};
__export(SnapManager_exports, {
  SnapManager: () => SnapManager
});
module.exports = __toCommonJS(SnapManager_exports);
var import_state = require("@tldraw/state");
var import_tlschema = require("@tldraw/tlschema");
var import_BoundsSnaps = require("./BoundsSnaps");
var import_HandleSnaps = require("./HandleSnaps");
class SnapManager {
  constructor(editor) {
    this.editor = editor;
    this.shapeBounds = new import_BoundsSnaps.BoundsSnaps(this);
    this.handles = new import_HandleSnaps.HandleSnaps(this);
  }
  shapeBounds;
  handles;
  _snapIndicators = (0, import_state.atom)("snapLines", void 0);
  getIndicators() {
    return this._snapIndicators.get() ?? import_state.EMPTY_ARRAY;
  }
  clearIndicators() {
    if (this.getIndicators().length) {
      this._snapIndicators.set(void 0);
    }
  }
  setIndicators(indicators) {
    this._snapIndicators.set(indicators);
  }
  getSnapThreshold() {
    return 8 / this.editor.getZoomLevel();
  }
  getSnappableShapes() {
    const { editor } = this;
    const renderingBounds = editor.getViewportPageBounds();
    const selectedShapeIds = editor.getSelectedShapeIds();
    const snappableShapes = /* @__PURE__ */ new Set();
    const collectSnappableShapesFromParent = (parentId) => {
      if ((0, import_tlschema.isShapeId)(parentId)) {
        const parent = editor.getShape(parentId);
        if (parent && editor.isShapeOfType(parent, "frame")) {
          snappableShapes.add(parentId);
        }
      }
      const sortedChildIds = editor.getSortedChildIdsForParent(parentId);
      for (const childId of sortedChildIds) {
        if (selectedShapeIds.includes(childId)) continue;
        const childShape = editor.getShape(childId);
        if (!childShape) continue;
        const util = editor.getShapeUtil(childShape);
        if (!util.canSnap(childShape)) continue;
        const pageBounds = editor.getShapePageBounds(childId);
        if (!(pageBounds && renderingBounds.includes(pageBounds))) continue;
        if (editor.isShapeOfType(childShape, "group")) {
          collectSnappableShapesFromParent(childId);
          continue;
        }
        snappableShapes.add(childId);
      }
    };
    collectSnappableShapesFromParent(this.getCurrentCommonAncestor() ?? editor.getCurrentPageId());
    return snappableShapes;
  }
  getCurrentCommonAncestor() {
    return this.editor.findCommonAncestor(this.editor.getSelectedShapes());
  }
}
__decorateClass([
  import_state.computed
], SnapManager.prototype, "getSnapThreshold", 1);
__decorateClass([
  import_state.computed
], SnapManager.prototype, "getSnappableShapes", 1);
__decorateClass([
  import_state.computed
], SnapManager.prototype, "getCurrentCommonAncestor", 1);
//# sourceMappingURL=SnapManager.js.map
