"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Watermark_exports = {};
__export(Watermark_exports, {
  WATERMARK_LOCAL_SRC: () => WATERMARK_LOCAL_SRC,
  WATERMARK_REMOTE_SRC: () => WATERMARK_REMOTE_SRC,
  Watermark: () => Watermark
});
module.exports = __toCommonJS(Watermark_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_state_react = require("@tldraw/state-react");
var import_utils = require("@tldraw/utils");
var import_react = __toESM(require("react"));
var import_useCanvasEvents = require("../hooks/useCanvasEvents");
var import_useEditor = require("../hooks/useEditor");
var import_assets = require("../utils/assets");
var import_debug_flags = require("../utils/debug-flags");
var import_dom = require("../utils/dom");
var import_watermarks = require("../watermarks");
var import_LicenseManager = require("./LicenseManager");
var import_LicenseProvider = require("./LicenseProvider");
const WATERMARK_REMOTE_SRC = `${(0, import_assets.getDefaultCdnBaseUrl)()}/watermarks/watermark-desktop.svg`;
const WATERMARK_LOCAL_SRC = `data:image/svg+xml;utf8,${encodeURIComponent(import_watermarks.watermarkDesktopSvg)}`;
let watermarkUrlPromise = null;
async function getWatermarkUrl(forceLocal) {
  if (forceLocal) {
    return WATERMARK_LOCAL_SRC;
  }
  if (!watermarkUrlPromise) {
    watermarkUrlPromise = Promise.race([
      // try and load the remote watermark, if it fails, fallback to the local one
      (async () => {
        try {
          const response = await (0, import_utils.fetch)(WATERMARK_REMOTE_SRC);
          if (!response.ok) return WATERMARK_LOCAL_SRC;
          const blob = await response.blob();
          return URL.createObjectURL(blob);
        } catch {
          return WATERMARK_LOCAL_SRC;
        }
      })(),
      // but if that's taking a long time (>3s) just show the local one anyway
      new Promise((resolve) => {
        setTimeout(() => {
          resolve(WATERMARK_LOCAL_SRC);
        }, 3e3);
      })
    ]);
  }
  return watermarkUrlPromise;
}
const Watermark = import_react.default.memo(function Watermark2({
  forceLocal = false
}) {
  const events = (0, import_useCanvasEvents.useCanvasEvents)();
  const editor = (0, import_useEditor.useEditor)();
  const licenseManager = (0, import_LicenseProvider.useLicenseContext)();
  const showWatermark = (0, import_state_react.useValue)(
    "show watermark",
    () => import_debug_flags.featureFlags.enableLicensing.get() && editor.getViewportScreenBounds().width > 760 && licenseManager.state.get() === "unlicensed",
    [editor, licenseManager]
  );
  const isDebugMode = (0, import_state_react.useValue)("debug mode", () => editor.getInstanceState().isDebugMode, [editor]);
  const isMenuOpen = (0, import_state_react.useValue)("is menu open", () => editor.getIsMenuOpen(), [editor]);
  const [src, setSrc] = (0, import_react.useState)(null);
  const shouldUseLocal = forceLocal || licenseManager.isDevelopment;
  (0, import_react.useEffect)(() => {
    if (!showWatermark) return;
    let isCancelled = false;
    (async () => {
      const src2 = await getWatermarkUrl(shouldUseLocal);
      if (isCancelled) return;
      setSrc(src2);
    })();
    return () => {
      isCancelled = true;
    };
  }, [shouldUseLocal, showWatermark]);
  if (!showWatermark || !src) return null;
  const className = import_LicenseManager.LicenseManager.className;
  const maskCss = `url('${src}') center 100% / 100% no-repeat`;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_jsx_runtime.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("style", { children: `
/* ------------------- SEE LICENSE -------------------
The tldraw watermark is part of tldraw's license. It is shown for unlicensed
users. By using this library, you agree to keep the watermark's behavior, 
keeping it visible, unobscured, and available to user-interaction.

To remove the watermark, please purchase a license at tldraw.dev.
*/

.${className} {
	position: absolute;
	bottom: var(--space-2);
	right: var(--space-2);
	width: 96px;
	height: 32px;
	z-index: 2147483647 !important;
	pointer-events: ${isMenuOpen ? "none" : "all"};
	background-color: color-mix(in srgb, var(--color-background) 62%, transparent);
	border-radius: 5px;
	padding: 2px;
	box-sizing: content-box;
}

.${className}[data-debug='true'] {
	bottom: 46px;
}

.${className} > a {
	position: absolute;
	width: 96px;
	height: 32px;
	pointer-events: none;
	cursor: inherit;
	color: var(--color-text);
	background-color: currentColor;
	opacity: .28;
}

@media (hover: hover) {
	.${className}:hover {
		background-color: var(--color-background);
		transition: background-color 0.2s ease-in-out;
		transition-delay: 0.32s;
	}
	.${className}:hover > a {
		animation: delayed_link 0.2s forwards ease-in-out;
		animation-delay: 0.32s;
	}
}

@keyframes delayed_link {
	0% {
		cursor: inherit;
		opacity: .38;
		pointer-events: none;
	}
	100% {
		cursor: pointer;
		opacity: 1;
		pointer-events: all;
	}
}
` }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className, "data-debug": isDebugMode, draggable: false, ...events, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      "a",
      {
        href: "https://tldraw.dev",
        target: "_blank",
        rel: "noreferrer",
        draggable: false,
        onPointerDown: import_dom.stopEventPropagation,
        style: { mask: maskCss, WebkitMask: maskCss }
      }
    ) })
  ] });
});
//# sourceMappingURL=Watermark.js.map
