import { EASINGS } from "./primitives/easings.mjs";
const DEFAULT_CAMERA_OPTIONS = {
  isLocked: false,
  wheelBehavior: "pan",
  panSpeed: 1,
  zoomSpeed: 1,
  zoomSteps: [0.1, 0.25, 0.5, 1, 2, 4, 8]
};
const DEFAULT_ANIMATION_OPTIONS = {
  duration: 0,
  easing: EASINGS.easeInOutCubic
};
const INTERNAL_POINTER_IDS = {
  CAMERA_MOVE: -10
};
const SIDES = ["top", "right", "bottom", "left"];
const LEFT_MOUSE_BUTTON = 0;
const RIGHT_MOUSE_BUTTON = 2;
const MIDDLE_MOUSE_BUTTON = 1;
const STYLUS_ERASER_BUTTON = 5;
const ZOOM_TO_FIT_PADDING = 128;
export {
  DEFAULT_ANIMATION_OPTIONS,
  DEFAULT_CAMERA_OPTIONS,
  INTERNAL_POINTER_IDS,
  LEFT_MOUSE_BUTTON,
  MIDDLE_MOUSE_BUTTON,
  RIGHT_MOUSE_BUTTON,
  SIDES,
  STYLUS_ERASER_BUTTON,
  ZOOM_TO_FIT_PADDING
};
//# sourceMappingURL=constants.mjs.map
