import { RESET_VALUE, computed, isUninitialized } from "@tldraw/state";
import { objectMapValues } from "@tldraw/utils";
const bindingsIndex = (editor) => {
  const { store } = editor;
  const bindingsHistory = store.query.filterHistory("binding");
  const bindingsQuery = store.query.records("binding");
  function fromScratch() {
    const allBindings = bindingsQuery.get();
    const shape2Binding = /* @__PURE__ */ new Map();
    for (const binding of allBindings) {
      const { fromId, toId } = binding;
      const bindingsForFromShape = shape2Binding.get(fromId);
      if (!bindingsForFromShape) {
        shape2Binding.set(fromId, [binding]);
      } else {
        bindingsForFromShape.push(binding);
      }
      const bindingsForToShape = shape2Binding.get(toId);
      if (!bindingsForToShape) {
        shape2Binding.set(toId, [binding]);
      } else {
        bindingsForToShape.push(binding);
      }
    }
    return shape2Binding;
  }
  return computed("arrowBindingsIndex", (_lastValue, lastComputedEpoch) => {
    if (isUninitialized(_lastValue)) {
      return fromScratch();
    }
    const lastValue = _lastValue;
    const diff = bindingsHistory.getDiffSince(lastComputedEpoch);
    if (diff === RESET_VALUE) {
      return fromScratch();
    }
    let nextValue = void 0;
    function removingBinding(binding) {
      nextValue ??= new Map(lastValue);
      const prevFrom = nextValue.get(binding.fromId);
      const nextFrom = prevFrom?.filter((b) => b.id !== binding.id);
      if (!nextFrom?.length) {
        nextValue.delete(binding.fromId);
      } else {
        nextValue.set(binding.fromId, nextFrom);
      }
      const prevTo = nextValue.get(binding.toId);
      const nextTo = prevTo?.filter((b) => b.id !== binding.id);
      if (!nextTo?.length) {
        nextValue.delete(binding.toId);
      } else {
        nextValue.set(binding.toId, nextTo);
      }
    }
    function ensureNewArray(shapeId) {
      nextValue ??= new Map(lastValue);
      let result = nextValue.get(shapeId);
      if (!result) {
        result = [];
        nextValue.set(shapeId, result);
      } else if (result === lastValue.get(shapeId)) {
        result = result.slice(0);
        nextValue.set(shapeId, result);
      }
      return result;
    }
    function addBinding(binding) {
      ensureNewArray(binding.fromId).push(binding);
      ensureNewArray(binding.toId).push(binding);
    }
    for (const changes of diff) {
      for (const newBinding of objectMapValues(changes.added)) {
        addBinding(newBinding);
      }
      for (const [prev, next] of objectMapValues(changes.updated)) {
        removingBinding(prev);
        addBinding(next);
      }
      for (const prev of objectMapValues(changes.removed)) {
        removingBinding(prev);
      }
    }
    return nextValue ?? lastValue;
  });
};
export {
  bindingsIndex
};
//# sourceMappingURL=bindingsIndex.mjs.map
