import { computed, isUninitialized } from "@tldraw/state";
function isShapeNotVisible(editor, id, viewportPageBounds) {
  const maskedPageBounds = editor.getShapeMaskedPageBounds(id);
  if (maskedPageBounds === void 0) return true;
  return !viewportPageBounds.includes(maskedPageBounds);
}
const notVisibleShapes = (editor) => {
  function fromScratch(editor2) {
    const shapes = editor2.getCurrentPageShapeIds();
    const viewportPageBounds = editor2.getViewportPageBounds();
    const notVisibleShapes2 = /* @__PURE__ */ new Set();
    shapes.forEach((id) => {
      if (isShapeNotVisible(editor2, id, viewportPageBounds)) {
        notVisibleShapes2.add(id);
      }
    });
    return notVisibleShapes2;
  }
  return computed("getCulledShapes", (prevValue) => {
    if (isUninitialized(prevValue)) {
      return fromScratch(editor);
    }
    const nextValue = fromScratch(editor);
    if (prevValue.size !== nextValue.size) return nextValue;
    for (const prev of prevValue) {
      if (!nextValue.has(prev)) {
        return nextValue;
      }
    }
    return prevValue;
  });
};
export {
  notVisibleShapes
};
//# sourceMappingURL=notVisibleShapes.mjs.map
