import { createShapeId } from "@tldraw/tlschema";
import { structuredClone } from "@tldraw/utils";
import { Vec } from "../../../../primitives/Vec.mjs";
import { StateNode } from "../../StateNode.mjs";
class Pointing extends StateNode {
  static id = "pointing";
  markId = "";
  wasFocusedOnEnter = false;
  onEnter = () => {
    this.wasFocusedOnEnter = !this.editor.getIsMenuOpen();
  };
  onPointerMove = (info) => {
    if (this.editor.inputs.isDragging) {
      const { originPagePoint } = this.editor.inputs;
      const shapeType = this.parent.shapeType;
      const id = createShapeId();
      this.markId = `creating:${id}`;
      this.editor.mark(this.markId);
      this.editor.createShapes([
        {
          id,
          type: shapeType,
          x: originPagePoint.x,
          y: originPagePoint.y,
          props: {
            w: 1,
            h: 1
          }
        }
      ]).select(id);
      this.editor.setCurrentTool("select.resizing", {
        ...info,
        target: "selection",
        handle: "bottom_right",
        isCreating: true,
        creationCursorOffset: { x: 1, y: 1 },
        onInteractionEnd: this.parent.id,
        onCreate: this.parent.onCreate
      });
    }
  };
  onPointerUp = () => {
    this.complete();
  };
  onCancel = () => {
    this.cancel();
  };
  onComplete = () => {
    this.complete();
  };
  onInterrupt = () => {
    this.cancel();
  };
  complete() {
    const { originPagePoint } = this.editor.inputs;
    if (!this.wasFocusedOnEnter) {
      return;
    }
    this.editor.mark(this.markId);
    const shapeType = this.parent.shapeType;
    const id = createShapeId();
    this.editor.mark(this.markId);
    this.editor.createShapes([
      {
        id,
        type: shapeType,
        x: originPagePoint.x,
        y: originPagePoint.y
      }
    ]);
    const shape = this.editor.getShape(id);
    if (!shape) {
      this.cancel();
      return;
    }
    let { w, h } = shape.props;
    const delta = new Vec(w / 2, h / 2);
    const parentTransform = this.editor.getShapeParentTransform(shape);
    if (parentTransform) delta.rot(-parentTransform.rotation());
    let scale = 1;
    if (this.editor.user.getIsDynamicResizeMode()) {
      scale = 1 / this.editor.getZoomLevel();
      w *= scale;
      h *= scale;
      delta.mul(scale);
    }
    const next = structuredClone(shape);
    next.x = shape.x - delta.x;
    next.y = shape.y - delta.y;
    next.props.w = w;
    next.props.h = h;
    if ("scale" in shape.props) {
      ;
      next.props.scale = scale;
    }
    this.editor.updateShape(next);
    this.editor.setSelectedShapes([id]);
    if (this.editor.getInstanceState().isToolLocked) {
      this.parent.transition("idle");
    } else {
      this.editor.setCurrentTool("select.idle");
    }
  }
  cancel() {
    this.parent.transition("idle");
  }
}
export {
  Pointing
};
//# sourceMappingURL=Pointing.mjs.map
