import { jsx } from "react/jsx-runtime";
import { createContext, useContext } from "react";
import { EditorContext } from "../../hooks/useEditor.mjs";
const Context = createContext(null);
function SvgExportContextProvider({
  context,
  editor,
  children
}) {
  return /* @__PURE__ */ jsx(EditorContext.Provider, { value: editor, children: /* @__PURE__ */ jsx(Context.Provider, { value: context, children }) });
}
function useSvgExportContext() {
  const ctx = useContext(Context);
  if (!ctx) return null;
  return { isDarkMode: ctx.isDarkMode };
}
export {
  SvgExportContextProvider,
  useSvgExportContext
};
//# sourceMappingURL=SvgExportContext.mjs.map
