import { useEffect } from "react";
import { useEditor } from "./useEditor.mjs";
function useCoarsePointer() {
  const editor = useEditor();
  useEffect(() => {
    let isCoarse = editor.getInstanceState().isCoarsePointer;
    const handlePointerDown = (e) => {
      const isCoarseEvent = e.pointerType !== "mouse";
      if (isCoarse === isCoarseEvent) return;
      isCoarse = isCoarseEvent;
      editor.updateInstanceState({ isCoarsePointer: isCoarseEvent });
    };
    window.addEventListener("pointerdown", handlePointerDown, { capture: true });
    const mql = window.matchMedia && window.matchMedia("(any-pointer: coarse)");
    const isForcedFinePointer = editor.environment.isFirefox && !editor.environment.isAndroid && !editor.environment.isIos;
    const handleMediaQueryChange = () => {
      const next = isForcedFinePointer ? false : mql.matches;
      if (isCoarse !== next) return;
      isCoarse = next;
      editor.updateInstanceState({ isCoarsePointer: next });
    };
    if (mql) {
      mql.addEventListener("change", handleMediaQueryChange);
      handleMediaQueryChange();
    }
    return () => {
      window.removeEventListener("pointerdown", handlePointerDown, { capture: true });
      if (mql) {
        mql.removeEventListener("change", handleMediaQueryChange);
      }
    };
  }, [editor]);
}
export {
  useCoarsePointer
};
//# sourceMappingURL=useCoarsePointer.mjs.map
