import React, { createContext } from "react";
const EditorContext = createContext(null);
function useEditor() {
  const editor = React.useContext(EditorContext);
  if (!editor) {
    throw new Error(
      "useEditor must be used inside of the <Tldraw /> or <TldrawEditor /> components"
    );
  }
  return editor;
}
export {
  EditorContext,
  useEditor
};
//# sourceMappingURL=useEditor.mjs.map
