import { Box } from "../Box.mjs";
import { Vec } from "../Vec.mjs";
import { intersectLineSegmentCircle } from "../intersect.mjs";
import { PI2, getPointOnCircle } from "../utils.mjs";
import { Geometry2d } from "./Geometry2d.mjs";
import { getVerticesCountForLength } from "./geometry-constants.mjs";
class Circle2d extends Geometry2d {
  constructor(config) {
    super({ isClosed: true, ...config });
    this.config = config;
    const { x = 0, y = 0, radius } = config;
    this.x = x;
    this.y = y;
    this._center = new Vec(radius + x, radius + y);
    this.radius = radius;
  }
  _center;
  radius;
  x;
  y;
  getBounds() {
    return new Box(this.x, this.y, this.radius * 2, this.radius * 2);
  }
  getVertices() {
    const { _center, radius } = this;
    const perimeter = PI2 * radius;
    const vertices = [];
    for (let i = 0, n = getVerticesCountForLength(perimeter); i < n; i++) {
      const angle = i / n * PI2;
      vertices.push(getPointOnCircle(_center, radius, angle));
    }
    return vertices;
  }
  nearestPoint(point) {
    const { _center, radius } = this;
    if (_center.equals(point)) return Vec.AddXY(_center, radius, 0);
    return _center.clone().add(point.clone().sub(_center).uni().mul(radius));
  }
  hitTestLineSegment(A, B, distance = 0) {
    const { _center, radius } = this;
    return intersectLineSegmentCircle(A, B, _center, radius + distance) !== null;
  }
  getSvgPathData() {
    const { _center, radius } = this;
    return `M${_center.x + radius},${_center.y} a${radius},${radius} 0 1,0 ${radius * 2},0a${radius},${radius} 0 1,0 -${radius * 2},0`;
  }
}
export {
  Circle2d
};
//# sourceMappingURL=Circle2d.mjs.map
