import { computed, react } from "@tldraw/state";
import { useMemo, useRef, useSyncExternalStore } from "react";
function useValue() {
  const args = arguments;
  const deps = args.length === 3 ? args[2] : [args[0]];
  const name = args.length === 3 ? args[0] : `useValue(${args[0].name})`;
  const isInRender = useRef(true);
  isInRender.current = true;
  const $val = useMemo(() => {
    if (args.length === 1) {
      return args[0];
    }
    return computed(name, () => {
      if (isInRender.current) {
        return args[1]();
      } else {
        try {
          return args[1]();
        } catch {
          return {};
        }
      }
    });
  }, deps);
  try {
    const { subscribe, getSnapshot } = useMemo(() => {
      return {
        subscribe: (listen) => {
          return react(`useValue(${name})`, () => {
            $val.get();
            listen();
          });
        },
        getSnapshot: () => $val.get()
      };
    }, [$val]);
    return useSyncExternalStore(subscribe, getSnapshot, getSnapshot);
  } finally {
    isInRender.current = false;
  }
}
export {
  useValue
};
//# sourceMappingURL=useValue.mjs.map
