import { singleton } from "./lib/helpers.mjs";
import { ArraySet } from "./lib/ArraySet.mjs";
import { atom, isAtom } from "./lib/Atom.mjs";
import {
  UNINITIALIZED,
  computed,
  getComputedInstance,
  isUninitialized,
  withDiff
} from "./lib/Computed.mjs";
import { EffectScheduler, react, reactor } from "./lib/EffectScheduler.mjs";
import { unsafe__withoutCapture, whyAmIRunning } from "./lib/capture.mjs";
import { EMPTY_ARRAY } from "./lib/helpers.mjs";
import { isSignal } from "./lib/isSignal.mjs";
import { transact, transaction } from "./lib/transactions.mjs";
import { RESET_VALUE } from "./lib/types.mjs";
const currentApiVersion = 1;
const actualApiVersion = singleton("apiVersion", () => currentApiVersion);
if (actualApiVersion !== currentApiVersion) {
  throw new Error(
    `You have multiple incompatible versions of @tldraw/state in your app. Please deduplicate the package.`
  );
}
export {
  ArraySet,
  EMPTY_ARRAY,
  EffectScheduler,
  RESET_VALUE,
  UNINITIALIZED,
  atom,
  computed,
  getComputedInstance,
  isAtom,
  isSignal,
  isUninitialized,
  react,
  reactor,
  transact,
  transaction,
  unsafe__withoutCapture,
  whyAmIRunning,
  withDiff
};
//# sourceMappingURL=index.mjs.map
