import { ArraySet } from "./ArraySet.mjs";
import { HistoryBuffer } from "./HistoryBuffer.mjs";
import { maybeCaptureParent, startCapturingParents, stopCapturingParents } from "./capture.mjs";
import { GLOBAL_START_EPOCH } from "./constants.mjs";
import { EMPTY_ARRAY, equals, haveParentsChanged, singleton } from "./helpers.mjs";
import { getGlobalEpoch, getIsReacting, getReactionEpoch } from "./transactions.mjs";
import { RESET_VALUE } from "./types.mjs";
import { logComputedGetterWarning } from "./warnings.mjs";
const UNINITIALIZED = Symbol.for("com.tldraw.state/UNINITIALIZED");
const isUninitialized = (value) => {
  return value === UNINITIALIZED;
};
const WithDiff = singleton(
  "WithDiff",
  () => (class WithDiff {
    constructor(value, diff) {
      this.value = value;
      this.diff = diff;
    }
  })
);
function withDiff(value, diff) {
  return new WithDiff(value, diff);
}
class __UNSAFE__Computed {
  constructor(name, derive, options) {
    this.name = name;
    this.derive = derive;
    if (options?.historyLength) {
      this.historyBuffer = new HistoryBuffer(options.historyLength);
    }
    this.computeDiff = options?.computeDiff;
    this.isEqual = options?.isEqual ?? equals;
  }
  lastChangedEpoch = GLOBAL_START_EPOCH;
  lastTraversedEpoch = GLOBAL_START_EPOCH;
  /**
   * The epoch when the reactor was last checked.
   */
  lastCheckedEpoch = GLOBAL_START_EPOCH;
  parentSet = new ArraySet();
  parents = [];
  parentEpochs = [];
  children = new ArraySet();
  // eslint-disable-next-line no-restricted-syntax
  get isActivelyListening() {
    return !this.children.isEmpty;
  }
  historyBuffer;
  // The last-computed value of this signal.
  state = UNINITIALIZED;
  // If the signal throws an error we stash it so we can rethrow it on the next get()
  error = null;
  computeDiff;
  isEqual;
  __unsafe__getWithoutCapture(ignoreErrors) {
    const isNew = this.lastChangedEpoch === GLOBAL_START_EPOCH;
    const globalEpoch = getGlobalEpoch();
    if (!isNew && (this.lastCheckedEpoch === globalEpoch || this.isActivelyListening && getIsReacting() && this.lastTraversedEpoch < getReactionEpoch() || !haveParentsChanged(this))) {
      this.lastCheckedEpoch = globalEpoch;
      if (this.error) {
        if (!ignoreErrors) {
          throw this.error.thrownValue;
        } else {
          return this.state;
        }
      } else {
        return this.state;
      }
    }
    try {
      startCapturingParents(this);
      const result = this.derive(this.state, this.lastCheckedEpoch);
      const newState = result instanceof WithDiff ? result.value : result;
      const isUninitialized2 = this.state === UNINITIALIZED;
      if (isUninitialized2 || !this.isEqual(newState, this.state)) {
        if (this.historyBuffer && !isUninitialized2) {
          const diff = result instanceof WithDiff ? result.diff : void 0;
          this.historyBuffer.pushEntry(
            this.lastChangedEpoch,
            getGlobalEpoch(),
            diff ?? this.computeDiff?.(this.state, newState, this.lastCheckedEpoch, getGlobalEpoch()) ?? RESET_VALUE
          );
        }
        this.lastChangedEpoch = getGlobalEpoch();
        this.state = newState;
      }
      this.error = null;
      this.lastCheckedEpoch = getGlobalEpoch();
      return this.state;
    } catch (e) {
      if (this.state !== UNINITIALIZED) {
        this.state = UNINITIALIZED;
        this.lastChangedEpoch = getGlobalEpoch();
      }
      this.lastCheckedEpoch = getGlobalEpoch();
      if (this.historyBuffer) {
        this.historyBuffer.clear();
      }
      this.error = { thrownValue: e };
      if (!ignoreErrors) throw e;
      return this.state;
    } finally {
      stopCapturingParents();
    }
  }
  get() {
    try {
      return this.__unsafe__getWithoutCapture();
    } finally {
      maybeCaptureParent(this);
    }
  }
  getDiffSince(epoch) {
    this.__unsafe__getWithoutCapture(true);
    maybeCaptureParent(this);
    if (epoch >= this.lastChangedEpoch) {
      return EMPTY_ARRAY;
    }
    return this.historyBuffer?.getChangesSince(epoch) ?? RESET_VALUE;
  }
}
const _Computed = singleton("Computed", () => __UNSAFE__Computed);
function computedMethodAnnotation(options = {}, _target, key, descriptor) {
  const originalMethod = descriptor.value;
  const derivationKey = Symbol.for("__@tldraw/state__computed__" + key);
  descriptor.value = function() {
    let d = this[derivationKey];
    if (!d) {
      d = new _Computed(key, originalMethod.bind(this), options);
      Object.defineProperty(this, derivationKey, {
        enumerable: false,
        configurable: false,
        writable: false,
        value: d
      });
    }
    return d.get();
  };
  descriptor.value[isComputedMethodKey] = true;
  return descriptor;
}
function computedAnnotation(options = {}, _target, key, descriptor) {
  if (descriptor.get) {
    logComputedGetterWarning();
    return computedGetterAnnotation(options, _target, key, descriptor);
  } else {
    return computedMethodAnnotation(options, _target, key, descriptor);
  }
}
function computedGetterAnnotation(options = {}, _target, key, descriptor) {
  const originalMethod = descriptor.get;
  const derivationKey = Symbol.for("__@tldraw/state__computed__" + key);
  descriptor.get = function() {
    let d = this[derivationKey];
    if (!d) {
      d = new _Computed(key, originalMethod.bind(this), options);
      Object.defineProperty(this, derivationKey, {
        enumerable: false,
        configurable: false,
        writable: false,
        value: d
      });
    }
    return d.get();
  };
  return descriptor;
}
const isComputedMethodKey = "@@__isComputedMethod__@@";
function getComputedInstance(obj, propertyName) {
  const key = Symbol.for("__@tldraw/state__computed__" + propertyName.toString());
  let inst = obj[key];
  if (!inst) {
    const val = obj[propertyName];
    if (typeof val === "function" && val[isComputedMethodKey]) {
      val.call(obj);
    }
    inst = obj[key];
  }
  return inst;
}
function computed() {
  if (arguments.length === 1) {
    const options = arguments[0];
    return (target, key, descriptor) => computedAnnotation(options, target, key, descriptor);
  } else if (typeof arguments[0] === "string") {
    return new _Computed(arguments[0], arguments[1], arguments[2]);
  } else {
    return computedAnnotation(void 0, arguments[0], arguments[1], arguments[2]);
  }
}
function isComputed(value) {
  return value && value instanceof _Computed;
}
export {
  UNINITIALIZED,
  WithDiff,
  _Computed,
  computed,
  getComputedInstance,
  isComputed,
  isUninitialized,
  withDiff
};
//# sourceMappingURL=Computed.mjs.map
