import { objectMapEntries } from "@tldraw/utils";
function createEmptyRecordsDiff() {
  return { added: {}, updated: {}, removed: {} };
}
function reverseRecordsDiff(diff) {
  const result = { added: diff.removed, removed: diff.added, updated: {} };
  for (const [from, to] of Object.values(diff.updated)) {
    result.updated[from.id] = [to, from];
  }
  return result;
}
function isRecordsDiffEmpty(diff) {
  return Object.keys(diff.added).length === 0 && Object.keys(diff.updated).length === 0 && Object.keys(diff.removed).length === 0;
}
function squashRecordDiffs(diffs) {
  const result = { added: {}, removed: {}, updated: {} };
  squashRecordDiffsMutable(result, diffs);
  return result;
}
function squashRecordDiffsMutable(target, diffs) {
  for (const diff of diffs) {
    for (const [id, value] of objectMapEntries(diff.added)) {
      if (target.removed[id]) {
        const original = target.removed[id];
        delete target.removed[id];
        if (original !== value) {
          target.updated[id] = [original, value];
        }
      } else {
        target.added[id] = value;
      }
    }
    for (const [id, [_from, to]] of objectMapEntries(diff.updated)) {
      if (target.added[id]) {
        target.added[id] = to;
        delete target.updated[id];
        delete target.removed[id];
        continue;
      }
      if (target.updated[id]) {
        target.updated[id] = [target.updated[id][0], to];
        delete target.removed[id];
        continue;
      }
      target.updated[id] = diff.updated[id];
      delete target.removed[id];
    }
    for (const [id, value] of objectMapEntries(diff.removed)) {
      if (target.added[id]) {
        delete target.added[id];
      } else if (target.updated[id]) {
        target.removed[id] = target.updated[id][0];
        delete target.updated[id];
      } else {
        target.removed[id] = value;
      }
    }
  }
}
export {
  createEmptyRecordsDiff,
  isRecordsDiffEmpty,
  reverseRecordsDiff,
  squashRecordDiffs,
  squashRecordDiffsMutable
};
//# sourceMappingURL=RecordsDiff.mjs.map
