"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var TLInstance_exports = {};
__export(TLInstance_exports, {
  TLINSTANCE_ID: () => TLINSTANCE_ID,
  createInstanceRecordType: () => createInstanceRecordType,
  instanceIdValidator: () => instanceIdValidator,
  instanceMigrations: () => instanceMigrations,
  instanceVersions: () => instanceVersions,
  pluckPreservingValues: () => pluckPreservingValues,
  shouldKeyBePreservedBetweenSessions: () => shouldKeyBePreservedBetweenSessions
});
module.exports = __toCommonJS(TLInstance_exports);
var import_store = require("@tldraw/store");
var import_utils = require("@tldraw/utils");
var import_validate = require("@tldraw/validate");
var import_geometry_types = require("../misc/geometry-types");
var import_id_validator = require("../misc/id-validator");
var import_TLCursor = require("../misc/TLCursor");
var import_TLOpacity = require("../misc/TLOpacity");
var import_TLScribble = require("../misc/TLScribble");
var import_TLPage = require("./TLPage");
const shouldKeyBePreservedBetweenSessions = {
  // This object defines keys that should be preserved across calls to loadSnapshot()
  id: false,
  // meta
  typeName: false,
  // meta
  currentPageId: false,
  // does not preserve because who knows if the page still exists
  opacityForNextShape: false,
  // does not preserve because it's a temporary state
  stylesForNextShape: false,
  // does not preserve because it's a temporary state
  followingUserId: false,
  // does not preserve because it's a temporary state
  highlightedUserIds: false,
  // does not preserve because it's a temporary state
  brush: false,
  // does not preserve because it's a temporary state
  cursor: false,
  // does not preserve because it's a temporary state
  scribbles: false,
  // does not preserve because it's a temporary state
  isFocusMode: true,
  // preserves because it's a user preference
  isDebugMode: true,
  // preserves because it's a user preference
  isToolLocked: true,
  // preserves because it's a user preference
  exportBackground: true,
  // preserves because it's a user preference
  screenBounds: true,
  // preserves because it's capturing the user's screen state
  insets: true,
  // preserves because it's capturing the user's screen state
  zoomBrush: false,
  // does not preserve because it's a temporary state
  chatMessage: false,
  // does not preserve because it's a temporary state
  isChatting: false,
  // does not preserve because it's a temporary state
  isPenMode: false,
  // does not preserve because it's a temporary state
  isGridMode: true,
  // preserves because it's a user preference
  isFocused: true,
  // preserves because obviously
  devicePixelRatio: true,
  // preserves because it captures the user's screen state
  isCoarsePointer: true,
  // preserves because it captures the user's screen state
  isHoveringCanvas: false,
  // does not preserve because it's a temporary state
  openMenus: false,
  // does not preserve because it's a temporary state
  isChangingStyle: false,
  // does not preserve because it's a temporary state
  isReadonly: true,
  // preserves because it's a config option
  meta: false,
  // does not preserve because who knows what's in there, leave it up to sdk users to save and reinstate
  duplicateProps: false
  //
};
const pluckPreservingValues = (val) => val ? (0, import_utils.filterEntries)(val, (key) => {
  return shouldKeyBePreservedBetweenSessions[key];
}) : null;
const instanceIdValidator = (0, import_id_validator.idValidator)("instance");
function createInstanceRecordType(stylesById) {
  const stylesForNextShapeValidators = {};
  for (const [id, style] of stylesById) {
    stylesForNextShapeValidators[id] = import_validate.T.optional(style);
  }
  const instanceTypeValidator = import_validate.T.model(
    "instance",
    import_validate.T.object({
      typeName: import_validate.T.literal("instance"),
      id: (0, import_id_validator.idValidator)("instance"),
      currentPageId: import_TLPage.pageIdValidator,
      followingUserId: import_validate.T.string.nullable(),
      brush: import_geometry_types.boxModelValidator.nullable(),
      opacityForNextShape: import_TLOpacity.opacityValidator,
      stylesForNextShape: import_validate.T.object(stylesForNextShapeValidators),
      cursor: import_TLCursor.cursorValidator,
      scribbles: import_validate.T.arrayOf(import_TLScribble.scribbleValidator),
      isFocusMode: import_validate.T.boolean,
      isDebugMode: import_validate.T.boolean,
      isToolLocked: import_validate.T.boolean,
      exportBackground: import_validate.T.boolean,
      screenBounds: import_geometry_types.boxModelValidator,
      insets: import_validate.T.arrayOf(import_validate.T.boolean),
      zoomBrush: import_geometry_types.boxModelValidator.nullable(),
      isPenMode: import_validate.T.boolean,
      isGridMode: import_validate.T.boolean,
      chatMessage: import_validate.T.string,
      isChatting: import_validate.T.boolean,
      highlightedUserIds: import_validate.T.arrayOf(import_validate.T.string),
      isFocused: import_validate.T.boolean,
      devicePixelRatio: import_validate.T.number,
      isCoarsePointer: import_validate.T.boolean,
      isHoveringCanvas: import_validate.T.boolean.nullable(),
      openMenus: import_validate.T.arrayOf(import_validate.T.string),
      isChangingStyle: import_validate.T.boolean,
      isReadonly: import_validate.T.boolean,
      meta: import_validate.T.jsonValue,
      duplicateProps: import_validate.T.object({
        shapeIds: import_validate.T.arrayOf((0, import_id_validator.idValidator)("shape")),
        offset: import_validate.T.object({
          x: import_validate.T.number,
          y: import_validate.T.number
        })
      }).nullable()
    })
  );
  return (0, import_store.createRecordType)("instance", {
    validator: instanceTypeValidator,
    scope: "session",
    ephemeralKeys: {
      currentPageId: false,
      meta: false,
      followingUserId: true,
      opacityForNextShape: true,
      stylesForNextShape: true,
      brush: true,
      cursor: true,
      scribbles: true,
      isFocusMode: true,
      isDebugMode: true,
      isToolLocked: true,
      exportBackground: true,
      screenBounds: true,
      insets: true,
      zoomBrush: true,
      isPenMode: true,
      isGridMode: true,
      chatMessage: true,
      isChatting: true,
      highlightedUserIds: true,
      isFocused: true,
      devicePixelRatio: true,
      isCoarsePointer: true,
      isHoveringCanvas: true,
      openMenus: true,
      isChangingStyle: true,
      isReadonly: true,
      duplicateProps: true
    }
  }).withDefaultProperties(
    () => ({
      followingUserId: null,
      opacityForNextShape: 1,
      stylesForNextShape: {},
      brush: null,
      scribbles: [],
      cursor: {
        type: "default",
        rotation: 0
      },
      isFocusMode: false,
      exportBackground: false,
      isDebugMode: process.env.NODE_ENV === "development",
      isToolLocked: false,
      screenBounds: { x: 0, y: 0, w: 1080, h: 720 },
      insets: [false, false, false, false],
      zoomBrush: null,
      isGridMode: false,
      isPenMode: false,
      chatMessage: "",
      isChatting: false,
      highlightedUserIds: [],
      isFocused: false,
      devicePixelRatio: typeof window === "undefined" ? 1 : window.devicePixelRatio,
      isCoarsePointer: false,
      isHoveringCanvas: null,
      openMenus: [],
      isChangingStyle: false,
      isReadonly: false,
      meta: {},
      duplicateProps: null
    })
  );
}
const instanceVersions = (0, import_store.createMigrationIds)("com.tldraw.instance", {
  AddTransparentExportBgs: 1,
  RemoveDialog: 2,
  AddToolLockMode: 3,
  RemoveExtraPropsForNextShape: 4,
  AddLabelColor: 5,
  AddFollowingUserId: 6,
  RemoveAlignJustify: 7,
  AddZoom: 8,
  AddVerticalAlign: 9,
  AddScribbleDelay: 10,
  RemoveUserId: 11,
  AddIsPenModeAndIsGridMode: 12,
  HoistOpacity: 13,
  AddChat: 14,
  AddHighlightedUserIds: 15,
  ReplacePropsForNextShapeWithStylesForNextShape: 16,
  AddMeta: 17,
  RemoveCursorColor: 18,
  AddLonelyProperties: 19,
  ReadOnlyReadonly: 20,
  AddHoveringCanvas: 21,
  AddScribbles: 22,
  AddInset: 23,
  AddDuplicateProps: 24,
  RemoveCanMoveCamera: 25
});
const instanceMigrations = (0, import_store.createRecordMigrationSequence)({
  sequenceId: "com.tldraw.instance",
  recordType: "instance",
  sequence: [
    {
      id: instanceVersions.AddTransparentExportBgs,
      up: (instance) => {
        return { ...instance, exportBackground: true };
      }
    },
    {
      id: instanceVersions.RemoveDialog,
      up: ({ dialog: _, ...instance }) => {
        return instance;
      }
    },
    {
      id: instanceVersions.AddToolLockMode,
      up: (instance) => {
        return { ...instance, isToolLocked: false };
      }
    },
    {
      id: instanceVersions.RemoveExtraPropsForNextShape,
      up: ({ propsForNextShape, ...instance }) => {
        return {
          ...instance,
          propsForNextShape: Object.fromEntries(
            Object.entries(propsForNextShape).filter(
              ([key]) => [
                "color",
                "labelColor",
                "dash",
                "fill",
                "size",
                "font",
                "align",
                "verticalAlign",
                "icon",
                "geo",
                "arrowheadStart",
                "arrowheadEnd",
                "spline"
              ].includes(key)
            )
          )
        };
      }
    },
    {
      id: instanceVersions.AddLabelColor,
      up: ({ propsForNextShape, ...instance }) => {
        return {
          ...instance,
          propsForNextShape: {
            ...propsForNextShape,
            labelColor: "black"
          }
        };
      }
    },
    {
      id: instanceVersions.AddFollowingUserId,
      up: (instance) => {
        return { ...instance, followingUserId: null };
      }
    },
    {
      id: instanceVersions.RemoveAlignJustify,
      up: (instance) => {
        let newAlign = instance.propsForNextShape.align;
        if (newAlign === "justify") {
          newAlign = "start";
        }
        return {
          ...instance,
          propsForNextShape: {
            ...instance.propsForNextShape,
            align: newAlign
          }
        };
      }
    },
    {
      id: instanceVersions.AddZoom,
      up: (instance) => {
        return { ...instance, zoomBrush: null };
      }
    },
    {
      id: instanceVersions.AddVerticalAlign,
      up: (instance) => {
        return {
          ...instance,
          propsForNextShape: {
            ...instance.propsForNextShape,
            verticalAlign: "middle"
          }
        };
      }
    },
    {
      id: instanceVersions.AddScribbleDelay,
      up: (instance) => {
        if (instance.scribble !== null) {
          return { ...instance, scribble: { ...instance.scribble, delay: 0 } };
        }
        return { ...instance };
      }
    },
    {
      id: instanceVersions.RemoveUserId,
      up: ({ userId: _, ...instance }) => {
        return instance;
      }
    },
    {
      id: instanceVersions.AddIsPenModeAndIsGridMode,
      up: (instance) => {
        return { ...instance, isPenMode: false, isGridMode: false };
      }
    },
    {
      id: instanceVersions.HoistOpacity,
      up: ({ propsForNextShape: { opacity, ...propsForNextShape }, ...instance }) => {
        return { ...instance, opacityForNextShape: Number(opacity ?? "1"), propsForNextShape };
      }
    },
    {
      id: instanceVersions.AddChat,
      up: (instance) => {
        return { ...instance, chatMessage: "", isChatting: false };
      }
    },
    {
      id: instanceVersions.AddHighlightedUserIds,
      up: (instance) => {
        return { ...instance, highlightedUserIds: [] };
      }
    },
    {
      id: instanceVersions.ReplacePropsForNextShapeWithStylesForNextShape,
      up: ({ propsForNextShape: _, ...instance }) => {
        return { ...instance, stylesForNextShape: {} };
      }
    },
    {
      id: instanceVersions.AddMeta,
      up: (record) => {
        return {
          ...record,
          meta: {}
        };
      }
    },
    {
      id: instanceVersions.RemoveCursorColor,
      up: (record) => {
        const { color: _, ...cursor } = record.cursor;
        return {
          ...record,
          cursor
        };
      }
    },
    {
      id: instanceVersions.AddLonelyProperties,
      up: (record) => {
        return {
          ...record,
          canMoveCamera: true,
          isFocused: false,
          devicePixelRatio: 1,
          isCoarsePointer: false,
          openMenus: [],
          isChangingStyle: false,
          isReadOnly: false
        };
      }
    },
    {
      id: instanceVersions.ReadOnlyReadonly,
      up: ({ isReadOnly: _isReadOnly, ...record }) => {
        return {
          ...record,
          isReadonly: _isReadOnly
        };
      }
    },
    {
      id: instanceVersions.AddHoveringCanvas,
      up: (record) => {
        return {
          ...record,
          isHoveringCanvas: null
        };
      }
    },
    {
      id: instanceVersions.AddScribbles,
      up: ({ scribble: _, ...record }) => {
        return {
          ...record,
          scribbles: []
        };
      }
    },
    {
      id: instanceVersions.AddInset,
      up: (record) => {
        return {
          ...record,
          insets: [false, false, false, false]
        };
      },
      down: ({ insets: _, ...record }) => {
        return {
          ...record
        };
      }
    },
    {
      id: instanceVersions.AddDuplicateProps,
      up: (record) => {
        return {
          ...record,
          duplicateProps: null
        };
      },
      down: ({ duplicateProps: _, ...record }) => {
        return {
          ...record
        };
      }
    },
    {
      id: instanceVersions.RemoveCanMoveCamera,
      up: ({ canMoveCamera: _, ...record }) => {
        return {
          ...record
        };
      },
      down: (instance) => {
        return { ...instance, canMoveCamera: true };
      }
    }
  ]
});
const TLINSTANCE_ID = "instance:instance";
//# sourceMappingURL=TLInstance.js.map
