"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var store_migrations_exports = {};
__export(store_migrations_exports, {
  storeMigrations: () => storeMigrations,
  storeVersions: () => Versions
});
module.exports = __toCommonJS(store_migrations_exports);
var import_store = require("@tldraw/store");
var import_utils = require("@tldraw/utils");
const Versions = (0, import_store.createMigrationIds)("com.tldraw.store", {
  RemoveCodeAndIconShapeTypes: 1,
  AddInstancePresenceType: 2,
  RemoveTLUserAndPresenceAndAddPointer: 3,
  RemoveUserDocument: 4
});
const storeMigrations = (0, import_store.createMigrationSequence)({
  sequenceId: "com.tldraw.store",
  retroactive: false,
  sequence: [
    {
      id: Versions.RemoveCodeAndIconShapeTypes,
      scope: "store",
      up: (store) => {
        for (const [id, record] of (0, import_utils.objectMapEntries)(store)) {
          if (record.typeName === "shape" && (record.type === "icon" || record.type === "code")) {
            delete store[id];
          }
        }
      }
    },
    {
      id: Versions.AddInstancePresenceType,
      scope: "store",
      up(_store) {
      }
    },
    {
      // remove user and presence records and add pointer records
      id: Versions.RemoveTLUserAndPresenceAndAddPointer,
      scope: "store",
      up: (store) => {
        for (const [id, record] of (0, import_utils.objectMapEntries)(store)) {
          if (record.typeName.match(/^(user|user_presence)$/)) {
            delete store[id];
          }
        }
      }
    },
    {
      // remove user document records
      id: Versions.RemoveUserDocument,
      scope: "store",
      up: (store) => {
        for (const [id, record] of (0, import_utils.objectMapEntries)(store)) {
          if (record.typeName.match("user_document")) {
            delete store[id];
          }
        }
      }
    }
  ]
});
//# sourceMappingURL=store-migrations.js.map
