import { T } from "@tldraw/validate";
import { createShapePropsMigrationIds, createShapePropsMigrationSequence } from "../records/TLShape.mjs";
import { DefaultColorStyle } from "../styles/TLColorStyle.mjs";
import { DefaultSizeStyle } from "../styles/TLSizeStyle.mjs";
import { DrawShapeSegment } from "./TLDrawShape.mjs";
const highlightShapeProps = {
  color: DefaultColorStyle,
  size: DefaultSizeStyle,
  segments: T.arrayOf(DrawShapeSegment),
  isComplete: T.boolean,
  isPen: T.boolean,
  scale: T.nonZeroNumber
};
const Versions = createShapePropsMigrationIds("highlight", {
  AddScale: 1
});
const highlightShapeMigrations = createShapePropsMigrationSequence({
  sequence: [
    {
      id: Versions.AddScale,
      up: (props) => {
        props.scale = 1;
      },
      down: (props) => {
        delete props.scale;
      }
    }
  ]
});
export {
  highlightShapeMigrations,
  highlightShapeProps,
  Versions as highlightShapeVersions
};
//# sourceMappingURL=TLHighlightShape.mjs.map
