"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var media_exports = {};
__export(media_exports, {
  DEFAULT_SUPPORTED_ANIMATED_IMAGE_TYPES: () => DEFAULT_SUPPORTED_ANIMATED_IMAGE_TYPES,
  DEFAULT_SUPPORTED_IMAGE_TYPES: () => DEFAULT_SUPPORTED_IMAGE_TYPES,
  DEFAULT_SUPPORTED_MEDIA_TYPE_LIST: () => DEFAULT_SUPPORTED_MEDIA_TYPE_LIST,
  DEFAULT_SUPPORTED_STATIC_IMAGE_TYPES: () => DEFAULT_SUPPORTED_STATIC_IMAGE_TYPES,
  DEFAULT_SUPPORTED_VECTOR_IMAGE_TYPES: () => DEFAULT_SUPPORTED_VECTOR_IMAGE_TYPES,
  DEFAULT_SUPPORT_VIDEO_TYPES: () => DEFAULT_SUPPORT_VIDEO_TYPES,
  MediaHelpers: () => MediaHelpers
});
module.exports = __toCommonJS(media_exports);
var import_network = require("../network");
var import_apng = require("./apng");
var import_avif = require("./avif");
var import_gif = require("./gif");
var import_png = require("./png");
var import_webp = require("./webp");
const DEFAULT_SUPPORTED_VECTOR_IMAGE_TYPES = Object.freeze(["image/svg+xml"]);
const DEFAULT_SUPPORTED_STATIC_IMAGE_TYPES = Object.freeze([
  "image/jpeg",
  "image/png",
  "image/webp"
]);
const DEFAULT_SUPPORTED_ANIMATED_IMAGE_TYPES = Object.freeze([
  "image/gif",
  "image/apng",
  "image/avif"
]);
const DEFAULT_SUPPORTED_IMAGE_TYPES = Object.freeze([
  ...DEFAULT_SUPPORTED_STATIC_IMAGE_TYPES,
  ...DEFAULT_SUPPORTED_VECTOR_IMAGE_TYPES,
  ...DEFAULT_SUPPORTED_ANIMATED_IMAGE_TYPES
]);
const DEFAULT_SUPPORT_VIDEO_TYPES = Object.freeze([
  "video/mp4",
  "video/webm",
  "video/quicktime"
]);
const DEFAULT_SUPPORTED_MEDIA_TYPE_LIST = [
  ...DEFAULT_SUPPORTED_IMAGE_TYPES,
  ...DEFAULT_SUPPORT_VIDEO_TYPES
].join(",");
class MediaHelpers {
  /**
   * Load a video from a url.
   * @public
   */
  static loadVideo(src) {
    return new Promise((resolve, reject) => {
      const video = document.createElement("video");
      video.onloadeddata = () => resolve(video);
      video.onerror = (e) => {
        console.error(e);
        reject(new Error("Could not load video"));
      };
      video.crossOrigin = "anonymous";
      video.src = src;
    });
  }
  /**
   * Load an image from a url.
   * @public
   */
  static loadImage(src) {
    return new Promise((resolve, reject) => {
      const img = (0, import_network.Image)();
      img.onload = () => resolve(img);
      img.onerror = (e) => {
        console.error(e);
        reject(new Error("Could not load image"));
      };
      img.crossOrigin = "anonymous";
      img.referrerPolicy = "strict-origin-when-cross-origin";
      img.src = src;
    });
  }
  /**
   * Get the size of a video blob
   *
   * @param src - A SharedBlob containing the video
   * @public
   */
  static async getVideoSize(blob) {
    return MediaHelpers.usingObjectURL(blob, async (url) => {
      const video = await MediaHelpers.loadVideo(url);
      return { w: video.videoWidth, h: video.videoHeight };
    });
  }
  /**
   * Get the size of an image blob
   *
   * @param dataURL - A Blob containing the image.
   * @public
   */
  static async getImageSize(blob) {
    const image = await MediaHelpers.usingObjectURL(blob, MediaHelpers.loadImage);
    try {
      if (blob.type === "image/png") {
        const view = new DataView(await blob.arrayBuffer());
        if (import_png.PngHelpers.isPng(view, 0)) {
          const physChunk = import_png.PngHelpers.findChunk(view, "pHYs");
          if (physChunk) {
            const physData = import_png.PngHelpers.parsePhys(view, physChunk.dataOffset);
            if (physData.unit === 0 && physData.ppux === physData.ppuy) {
              const pixelRatio = Math.max(physData.ppux / 2834.5, 1);
              return {
                w: Math.round(image.naturalWidth / pixelRatio),
                h: Math.round(image.naturalHeight / pixelRatio)
              };
            }
          }
        }
      }
    } catch (err) {
      console.error(err);
      return { w: image.naturalWidth, h: image.naturalHeight };
    }
    return { w: image.naturalWidth, h: image.naturalHeight };
  }
  static async isAnimated(file) {
    if (file.type === "image/gif") {
      return (0, import_gif.isGifAnimated)(await file.arrayBuffer());
    }
    if (file.type === "image/avif") {
      return (0, import_avif.isAvifAnimated)(await file.arrayBuffer());
    }
    if (file.type === "image/webp") {
      return (0, import_webp.isWebpAnimated)(await file.arrayBuffer());
    }
    if (file.type === "image/apng") {
      return (0, import_apng.isApngAnimated)(await file.arrayBuffer());
    }
    return false;
  }
  static isAnimatedImageType(mimeType) {
    return DEFAULT_SUPPORTED_ANIMATED_IMAGE_TYPES.includes(mimeType || "");
  }
  static isStaticImageType(mimeType) {
    return DEFAULT_SUPPORTED_STATIC_IMAGE_TYPES.includes(mimeType || "");
  }
  static isVectorImageType(mimeType) {
    return DEFAULT_SUPPORTED_VECTOR_IMAGE_TYPES.includes(mimeType || "");
  }
  static isImageType(mimeType) {
    return DEFAULT_SUPPORTED_IMAGE_TYPES.includes(mimeType);
  }
  static async usingObjectURL(blob, fn) {
    const url = URL.createObjectURL(blob);
    try {
      return await fn(url);
    } finally {
      URL.revokeObjectURL(url);
    }
  }
}
//# sourceMappingURL=media.js.map
