import { default as default2 } from "lodash.throttle";
import { default as default3 } from "lodash.uniq";
import { PerformanceTracker } from "./lib/PerformanceTracker.mjs";
import {
  areArraysShallowEqual,
  compact,
  dedupe,
  last,
  minBy,
  partition,
  rotateArray
} from "./lib/array.mjs";
import { WeakCache } from "./lib/cache.mjs";
import {
  Result,
  assert,
  assertExists,
  exhaustiveSwitchError,
  promiseWithResolve
} from "./lib/control.mjs";
import { debounce } from "./lib/debounce.mjs";
import { annotateError, getErrorAnnotations } from "./lib/error.mjs";
import { FileHelpers } from "./lib/file.mjs";
import { noop, omitFromStackTrace } from "./lib/function.mjs";
import { getHashForBuffer, getHashForObject, getHashForString, lns } from "./lib/hash.mjs";
import { getFirstFromIterable } from "./lib/iterable.mjs";
import {
  DEFAULT_SUPPORTED_IMAGE_TYPES,
  DEFAULT_SUPPORTED_MEDIA_TYPE_LIST,
  DEFAULT_SUPPORT_VIDEO_TYPES,
  MediaHelpers
} from "./lib/media/media.mjs";
import { PngHelpers } from "./lib/media/png.mjs";
import { Image, fetch } from "./lib/network.mjs";
import { invLerp, lerp, modulate, rng } from "./lib/number.mjs";
import {
  areObjectsShallowEqual,
  filterEntries,
  getOwnProperty,
  hasOwnProperty,
  mapObjectMapValues,
  objectMapEntries,
  objectMapFromEntries,
  objectMapKeys,
  objectMapValues
} from "./lib/object.mjs";
import { measureAverageDuration, measureCbDuration, measureDuration } from "./lib/perf.mjs";
import {
  ZERO_INDEX_KEY,
  getIndexAbove,
  getIndexBelow,
  getIndexBetween,
  getIndices,
  getIndicesAbove,
  getIndicesBelow,
  getIndicesBetween,
  sortByIndex,
  validateIndexKey
} from "./lib/reordering/reordering.mjs";
import { sortById } from "./lib/sort.mjs";
import {
  clearLocalStorage,
  clearSessionStorage,
  deleteFromLocalStorage,
  deleteFromSessionStorage,
  getFromLocalStorage,
  getFromSessionStorage,
  setInLocalStorage,
  setInSessionStorage
} from "./lib/storage.mjs";
import { fpsThrottle, throttleToNextFrame } from "./lib/throttle.mjs";
import { Timers } from "./lib/timers.mjs";
import {
  STRUCTURED_CLONE_OBJECT_PROTOTYPE,
  isDefined,
  isNativeStructuredClone,
  isNonNull,
  isNonNullish,
  structuredClone
} from "./lib/value.mjs";
import { warnDeprecatedGetter, warnOnce } from "./lib/warn.mjs";
export {
  DEFAULT_SUPPORTED_IMAGE_TYPES,
  DEFAULT_SUPPORTED_MEDIA_TYPE_LIST,
  DEFAULT_SUPPORT_VIDEO_TYPES,
  FileHelpers,
  Image,
  MediaHelpers,
  PerformanceTracker,
  PngHelpers,
  Result,
  STRUCTURED_CLONE_OBJECT_PROTOTYPE,
  Timers,
  WeakCache,
  ZERO_INDEX_KEY,
  annotateError,
  areArraysShallowEqual,
  areObjectsShallowEqual,
  assert,
  assertExists,
  clearLocalStorage,
  clearSessionStorage,
  compact,
  debounce,
  dedupe,
  deleteFromLocalStorage,
  deleteFromSessionStorage,
  exhaustiveSwitchError,
  fetch,
  filterEntries,
  fpsThrottle,
  getErrorAnnotations,
  getFirstFromIterable,
  getFromLocalStorage,
  getFromSessionStorage,
  getHashForBuffer,
  getHashForObject,
  getHashForString,
  getIndexAbove,
  getIndexBelow,
  getIndexBetween,
  getIndices,
  getIndicesAbove,
  getIndicesBelow,
  getIndicesBetween,
  getOwnProperty,
  hasOwnProperty,
  invLerp,
  isDefined,
  isNativeStructuredClone,
  isNonNull,
  isNonNullish,
  last,
  lerp,
  lns,
  mapObjectMapValues,
  measureAverageDuration,
  measureCbDuration,
  measureDuration,
  minBy,
  modulate,
  noop,
  objectMapEntries,
  objectMapFromEntries,
  objectMapKeys,
  objectMapValues,
  omitFromStackTrace,
  partition,
  promiseWithResolve,
  rng,
  rotateArray,
  setInLocalStorage,
  setInSessionStorage,
  sortById,
  sortByIndex,
  structuredClone,
  default2 as throttle,
  throttleToNextFrame,
  default3 as uniq,
  validateIndexKey,
  warnDeprecatedGetter,
  warnOnce
};
//# sourceMappingURL=index.mjs.map
