function rotateArray(arr, offset) {
  return arr.map((_, i) => arr[(i + offset) % arr.length]);
}
function dedupe(input, equals) {
  const result = [];
  mainLoop: for (const item of input) {
    for (const existing of result) {
      if (equals ? equals(item, existing) : item === existing) {
        continue mainLoop;
      }
    }
    result.push(item);
  }
  return result;
}
function compact(arr) {
  return arr.filter((i) => i !== void 0 && i !== null);
}
function last(arr) {
  return arr[arr.length - 1];
}
function minBy(arr, fn) {
  let min;
  let minVal = Infinity;
  for (const item of arr) {
    const val = fn(item);
    if (val < minVal) {
      min = item;
      minVal = val;
    }
  }
  return min;
}
function partition(arr, predicate) {
  const satisfies = [];
  const doesNotSatisfy = [];
  for (const item of arr) {
    if (predicate(item)) {
      satisfies.push(item);
    } else {
      doesNotSatisfy.push(item);
    }
  }
  return [satisfies, doesNotSatisfy];
}
function areArraysShallowEqual(arr1, arr2) {
  if (arr1 === arr2) return true;
  if (arr1.length !== arr2.length) return false;
  for (let i = 0; i < arr1.length; i++) {
    if (!Object.is(arr1[i], arr2[i])) {
      return false;
    }
  }
  return true;
}
export {
  areArraysShallowEqual,
  compact,
  dedupe,
  last,
  minBy,
  partition,
  rotateArray
};
//# sourceMappingURL=array.mjs.map
