function hasOwnProperty(obj, key) {
  return Object.prototype.hasOwnProperty.call(obj, key);
}
function getOwnProperty(obj, key) {
  if (!hasOwnProperty(obj, key)) {
    return void 0;
  }
  return obj[key];
}
function objectMapKeys(object) {
  return Object.keys(object);
}
function objectMapValues(object) {
  return Object.values(object);
}
function objectMapEntries(object) {
  return Object.entries(object);
}
function objectMapFromEntries(entries) {
  return Object.fromEntries(entries);
}
function filterEntries(object, predicate) {
  const result = {};
  let didChange = false;
  for (const [key, value] of objectMapEntries(object)) {
    if (predicate(key, value)) {
      result[key] = value;
    } else {
      didChange = true;
    }
  }
  return didChange ? result : object;
}
function mapObjectMapValues(object, mapper) {
  const result = {};
  for (const [key, value] of objectMapEntries(object)) {
    const newValue = mapper(key, value);
    result[key] = newValue;
  }
  return result;
}
function areObjectsShallowEqual(obj1, obj2) {
  if (obj1 === obj2) return true;
  const keys1 = new Set(Object.keys(obj1));
  const keys2 = new Set(Object.keys(obj2));
  if (keys1.size !== keys2.size) return false;
  for (const key of keys1) {
    if (!keys2.has(key)) return false;
    if (!Object.is(obj1[key], obj2[key])) return false;
  }
  return true;
}
export {
  areObjectsShallowEqual,
  filterEntries,
  getOwnProperty,
  hasOwnProperty,
  mapObjectMapValues,
  objectMapEntries,
  objectMapFromEntries,
  objectMapKeys,
  objectMapValues
};
//# sourceMappingURL=object.mjs.map
