/**
 * @abstract
 * @class Autolinker.htmlParser.HtmlNode
 *
 * Represents an HTML node found in an input string. An HTML node is one of the
 * following:
 *
 * 1. An {@link Autolinker.htmlParser.ElementNode ElementNode}, which represents
 *    HTML tags.
 * 2. A {@link Autolinker.htmlParser.CommentNode CommentNode}, which represents
 *    HTML comments.
 * 3. A {@link Autolinker.htmlParser.TextNode TextNode}, which represents text
 *    outside or within HTML tags.
 * 4. A {@link Autolinker.htmlParser.EntityNode EntityNode}, which represents
 *    one of the known HTML entities that Autolinker looks for. This includes
 *    common ones such as &amp;quot; and &amp;nbsp;
 */
export declare abstract class HtmlNode {
    /**
     * @cfg {Number} offset (required)
     *
     * The offset of the HTML node in the original text that was parsed.
     */
    offset: number;
    /**
     * @cfg {String} text (required)
     *
     * The text that was matched for the HtmlNode.
     *
     * - In the case of an {@link Autolinker.htmlParser.ElementNode ElementNode},
     *   this will be the tag's text.
     * - In the case of an {@link Autolinker.htmlParser.CommentNode CommentNode},
     *   this will be the comment's text.
     * - In the case of a {@link Autolinker.htmlParser.TextNode TextNode}, this
     *   will be the text itself.
     * - In the case of a {@link Autolinker.htmlParser.EntityNode EntityNode},
     *   this will be the text of the HTML entity.
     */
    text: string;
    /**
     * @method constructor
     * @param {Object} cfg The configuration properties for the Match instance,
     * specified in an Object (map).
     */
    constructor(cfg: HtmlNodeConfig);
    /**
     * Returns a string name for the type of node that this class represents.
     *
     * @abstract
     * @return {String}
     */
    abstract getType(): string;
    /**
     * Retrieves the {@link #offset} of the HtmlNode. This is the offset of the
     * HTML node in the original string that was parsed.
     *
     * @return {Number}
     */
    getOffset(): number;
    /**
     * Retrieves the {@link #text} for the HtmlNode.
     *
     * @return {String}
     */
    getText(): string;
}
export interface HtmlNodeConfig {
    offset: number;
    text: string;
}
