import * as tslib_1 from "tslib";
import { HtmlNode } from "./html-node";
/**
 * @class Autolinker.htmlParser.CommentNode
 * @extends Autolinker.htmlParser.HtmlNode
 *
 * Represents an HTML comment node that has been parsed by the
 * {@link Autolinker.htmlParser.HtmlParser}.
 *
 * See this class's superclass ({@link Autolinker.htmlParser.HtmlNode}) for more
 * details.
 */
var CommentNode = /** @class */ (function (_super) {
    tslib_1.__extends(CommentNode, _super);
    /**
     * @method constructor
     * @param {Object} cfg The configuration options for this class, specified
     *   in an Object.
     */
    function CommentNode(cfg) {
        var _this = _super.call(this, cfg) || this;
        /**
         * @cfg {String} comment (required)
         *
         * The text inside the comment tag. This text is stripped of any leading or
         * trailing whitespace.
         */
        _this.comment = ''; // default value just to get the above doc comment in the ES5 output and documentation generator
        _this.comment = cfg.comment;
        return _this;
    }
    /**
     * Returns a string name for the type of node that this class represents.
     *
     * @return {String}
     */
    CommentNode.prototype.getType = function () {
        return 'comment';
    };
    /**
     * Returns the comment inside the comment tag.
     *
     * @return {String}
     */
    CommentNode.prototype.getComment = function () {
        return this.comment;
    };
    return CommentNode;
}(HtmlNode));
export { CommentNode };

//# sourceMappingURL=comment-node.js.map
