import { Matcher } from "./matcher";
import { Match } from "../match/match";
/**
 * @class Autolinker.matcher.Email
 * @extends Autolinker.matcher.Matcher
 *
 * Matcher to find email matches in an input string.
 *
 * See this class's superclass ({@link Autolinker.matcher.Matcher}) for more details.
 */
export declare class EmailMatcher extends Matcher {
    /**
     * The regular expression to match email addresses. Example match:
     *
     *     person@place.com
     *
     * @protected
     * @property {RegExp} matcherRegex
     */
    protected matcherRegex: RegExp;
    /**
     * @inheritdoc
     */
    parseMatches(text: string): Match[];
}
