import * as tslib_1 from "tslib";
import { Matcher } from "./matcher";
import { alphaNumericAndMarksCharsStr, getDomainNameStr } from "../regex-lib";
import { tldRegex } from "./tld-regex";
import { EmailMatch } from "../match/email-match";
/**
 * @class Autolinker.matcher.Email
 * @extends Autolinker.matcher.Matcher
 *
 * Matcher to find email matches in an input string.
 *
 * See this class's superclass ({@link Autolinker.matcher.Matcher}) for more details.
 */
var EmailMatcher = /** @class */ (function (_super) {
    tslib_1.__extends(EmailMatcher, _super);
    function EmailMatcher() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * The regular expression to match email addresses. Example match:
         *
         *     person@place.com
         *
         * @protected
         * @property {RegExp} matcherRegex
         */
        _this.matcherRegex = (function () {
            var specialCharacters = '!#$%&\'*+\\-\\/=?^_`{|}~', restrictedSpecialCharacters = '\\s"(),:;<>@\\[\\]', validCharacters = alphaNumericAndMarksCharsStr + specialCharacters, validRestrictedCharacters = validCharacters + restrictedSpecialCharacters, emailRegex = new RegExp('(?:[' + validCharacters + '](?:[' + validCharacters + ']|\\.(?!\\.|@))*|\\"[' + validRestrictedCharacters + '.]+\\")@');
            return new RegExp([
                emailRegex.source,
                getDomainNameStr(1),
                '\\.', tldRegex.source // '.com', '.net', etc
            ].join(""), 'gi');
        })();
        return _this;
    }
    /**
     * @inheritdoc
     */
    EmailMatcher.prototype.parseMatches = function (text) {
        var matcherRegex = this.matcherRegex, tagBuilder = this.tagBuilder, matches = [], match;
        while ((match = matcherRegex.exec(text)) !== null) {
            var matchedText = match[0];
            matches.push(new EmailMatch({
                tagBuilder: tagBuilder,
                matchedText: matchedText,
                offset: match.index,
                email: matchedText
            }));
        }
        return matches;
    };
    return EmailMatcher;
}(Matcher));
export { EmailMatcher };

//# sourceMappingURL=email-matcher.js.map
