"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DrawShapeUtil_exports = {};
__export(DrawShapeUtil_exports, {
  DrawShapeUtil: () => DrawShapeUtil
});
module.exports = __toCommonJS(DrawShapeUtil_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_ShapeFill = require("../shared/ShapeFill");
var import_default_shape_constants = require("../shared/default-shape-constants");
var import_defaultStyleDefs = require("../shared/defaultStyleDefs");
var import_getStrokePoints = require("../shared/freehand/getStrokePoints");
var import_svg = require("../shared/freehand/svg");
var import_svgInk = require("../shared/freehand/svgInk");
var import_useDefaultColorTheme = require("../shared/useDefaultColorTheme");
var import_getPath = require("./getPath");
class DrawShapeUtil extends import_editor.ShapeUtil {
  static type = "draw";
  static props = import_editor.drawShapeProps;
  static migrations = import_editor.drawShapeMigrations;
  hideResizeHandles = (shape) => getIsDot(shape);
  hideRotateHandle = (shape) => getIsDot(shape);
  hideSelectionBoundsFg = (shape) => getIsDot(shape);
  getDefaultProps() {
    return {
      segments: [],
      color: "black",
      fill: "none",
      dash: "draw",
      size: "m",
      isComplete: false,
      isClosed: false,
      isPen: false,
      scale: 1
    };
  }
  getGeometry(shape) {
    const points = (0, import_getPath.getPointsFromSegments)(shape.props.segments);
    const sw = (import_default_shape_constants.STROKE_SIZES[shape.props.size] + 1) * shape.props.scale;
    if (shape.props.segments.length === 1) {
      const box = import_editor.Box.FromPoints(points);
      if (box.width < sw * 2 && box.height < sw * 2) {
        return new import_editor.Circle2d({
          x: -sw,
          y: -sw,
          radius: sw,
          isFilled: true
        });
      }
    }
    const strokePoints = (0, import_getStrokePoints.getStrokePoints)(
      points,
      (0, import_getPath.getFreehandOptions)(shape.props, sw, shape.props.isPen, true)
    ).map((p) => p.point);
    if (shape.props.isClosed) {
      return new import_editor.Polygon2d({
        points: strokePoints,
        isFilled: shape.props.fill !== "none"
      });
    }
    return new import_editor.Polyline2d({
      points: strokePoints
    });
  }
  component(shape) {
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_editor.SVGContainer, { id: shape.id, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DrawShapeSvg, { shape, zoomLevel: this.editor.getZoomLevel() }) });
  }
  indicator(shape) {
    const allPointsFromSegments = (0, import_getPath.getPointsFromSegments)(shape.props.segments);
    let sw = (import_default_shape_constants.STROKE_SIZES[shape.props.size] + 1) * shape.props.scale;
    const zoomLevel = this.editor.getZoomLevel();
    const forceSolid = zoomLevel < 0.5 && zoomLevel < 1.5 / sw;
    if (!forceSolid && !shape.props.isPen && shape.props.dash === "draw" && allPointsFromSegments.length === 1) {
      sw += (0, import_editor.rng)(shape.id)() * (sw / 6);
    }
    const showAsComplete = shape.props.isComplete || (0, import_editor.last)(shape.props.segments)?.type === "straight";
    const options = (0, import_getPath.getFreehandOptions)(shape.props, sw, showAsComplete, true);
    const strokePoints = (0, import_getStrokePoints.getStrokePoints)(allPointsFromSegments, options);
    const solidStrokePath = strokePoints.length > 1 ? (0, import_svg.getSvgPathFromStrokePoints)(strokePoints, shape.props.isClosed) : getDot(allPointsFromSegments[0], sw);
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("path", { d: solidStrokePath });
  }
  toSvg(shape, ctx) {
    ctx.addExportDef((0, import_defaultStyleDefs.getFillDefForExport)(shape.props.fill));
    const scaleFactor = 1 / shape.props.scale;
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("g", { transform: `scale(${scaleFactor})`, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DrawShapeSvg, { shape, zoomLevel: 1 }) });
  }
  getCanvasSvgDefs() {
    return [(0, import_defaultStyleDefs.getFillDefForCanvas)()];
  }
  onResize = (shape, info) => {
    const { scaleX, scaleY } = info;
    const newSegments = [];
    for (const segment of shape.props.segments) {
      newSegments.push({
        ...segment,
        points: segment.points.map(({ x, y, z }) => {
          return {
            x: (0, import_editor.toFixed)(scaleX * x),
            y: (0, import_editor.toFixed)(scaleY * y),
            z
          };
        })
      });
    }
    return {
      props: {
        segments: newSegments
      }
    };
  };
  expandSelectionOutlinePx(shape) {
    const multiplier = shape.props.dash === "draw" ? 1.6 : 1;
    return import_default_shape_constants.STROKE_SIZES[shape.props.size] * multiplier / 2 * shape.props.scale;
  }
}
function getDot(point, sw) {
  const r = (sw + 1) * 0.5;
  return `M ${point.x} ${point.y} m -${r}, 0 a ${r},${r} 0 1,0 ${r * 2},0 a ${r},${r} 0 1,0 -${r * 2},0`;
}
function getIsDot(shape) {
  return shape.props.segments.length === 1 && shape.props.segments[0].points.length < 2;
}
function DrawShapeSvg({ shape, zoomLevel }) {
  const theme = (0, import_useDefaultColorTheme.useDefaultColorTheme)();
  const allPointsFromSegments = (0, import_getPath.getPointsFromSegments)(shape.props.segments);
  const showAsComplete = shape.props.isComplete || (0, import_editor.last)(shape.props.segments)?.type === "straight";
  let sw = (import_default_shape_constants.STROKE_SIZES[shape.props.size] + 1) * shape.props.scale;
  const forceSolid = zoomLevel < 0.5 && zoomLevel < 1.5 / sw;
  if (!forceSolid && !shape.props.isPen && shape.props.dash === "draw" && allPointsFromSegments.length === 1) {
    sw += (0, import_editor.rng)(shape.id)() * (sw / 6);
  }
  const options = (0, import_getPath.getFreehandOptions)(shape.props, sw, showAsComplete, forceSolid);
  if (!forceSolid && shape.props.dash === "draw") {
    return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_jsx_runtime.Fragment, { children: [
      shape.props.isClosed && shape.props.fill && allPointsFromSegments.length > 1 ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        import_ShapeFill.ShapeFill,
        {
          d: (0, import_svg.getSvgPathFromStrokePoints)(
            (0, import_getStrokePoints.getStrokePoints)(allPointsFromSegments, options),
            shape.props.isClosed
          ),
          theme,
          color: shape.props.color,
          fill: shape.props.isClosed ? shape.props.fill : "none",
          scale: shape.props.scale
        }
      ) : null,
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        "path",
        {
          d: (0, import_svgInk.svgInk)(allPointsFromSegments, options),
          strokeLinecap: "round",
          fill: theme[shape.props.color].solid
        }
      )
    ] });
  }
  const strokePoints = (0, import_getStrokePoints.getStrokePoints)(allPointsFromSegments, options);
  const isDot = strokePoints.length < 2;
  const solidStrokePath = isDot ? getDot(allPointsFromSegments[0], 0) : (0, import_svg.getSvgPathFromStrokePoints)(strokePoints, shape.props.isClosed);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_jsx_runtime.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_ShapeFill.ShapeFill,
      {
        d: solidStrokePath,
        theme,
        color: shape.props.color,
        fill: isDot || shape.props.isClosed ? shape.props.fill : "none",
        scale: shape.props.scale
      }
    ),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      "path",
      {
        d: solidStrokePath,
        strokeLinecap: "round",
        fill: isDot ? theme[shape.props.color].solid : "none",
        stroke: theme[shape.props.color].solid,
        strokeWidth: sw,
        strokeDasharray: isDot ? "none" : (0, import_getPath.getDrawShapeStrokeDashArray)(shape, sw),
        strokeDashoffset: "0"
      }
    )
  ] });
}
//# sourceMappingURL=DrawShapeUtil.js.map
