"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Pointing_exports = {};
__export(Pointing_exports, {
  Pointing: () => Pointing
});
module.exports = __toCommonJS(Pointing_exports);
var import_editor = require("@tldraw/editor");
const MINIMUM_DISTANCE_BETWEEN_SHIFT_CLICKED_HANDLES = 2;
class Pointing extends import_editor.StateNode {
  static id = "pointing";
  shape = {};
  markId;
  onEnter = (info) => {
    const { inputs } = this.editor;
    const { currentPagePoint } = inputs;
    this.markId = void 0;
    const shape = info.shapeId && this.editor.getShape(info.shapeId);
    if (shape && inputs.shiftKey) {
      this.markId = `creating:${shape.id}`;
      this.editor.mark(this.markId);
      this.shape = shape;
      const handles = this.editor.getShapeHandles(this.shape);
      if (!handles) return;
      const vertexHandles = handles.filter((h) => h.type === "vertex").sort(import_editor.sortByIndex);
      const endHandle = vertexHandles[vertexHandles.length - 1];
      const prevEndHandle = vertexHandles[vertexHandles.length - 2];
      const shapePagePoint = import_editor.Mat.applyToPoint(
        this.editor.getShapeParentTransform(this.shape),
        new import_editor.Vec(this.shape.x, this.shape.y)
      );
      const nextPoint = import_editor.Vec.Sub(currentPagePoint, shapePagePoint).addXY(0.1, 0.1);
      const points = (0, import_editor.structuredClone)(this.shape.props.points);
      if (import_editor.Vec.DistMin(endHandle, prevEndHandle, MINIMUM_DISTANCE_BETWEEN_SHIFT_CLICKED_HANDLES) || import_editor.Vec.DistMin(nextPoint, endHandle, MINIMUM_DISTANCE_BETWEEN_SHIFT_CLICKED_HANDLES)) {
        points[endHandle.id] = {
          id: endHandle.id,
          index: endHandle.index,
          x: nextPoint.x,
          y: nextPoint.y
        };
      } else {
        const nextIndex = (0, import_editor.getIndexAbove)(endHandle.index);
        points[nextIndex] = {
          id: nextIndex,
          index: nextIndex,
          x: nextPoint.x,
          y: nextPoint.y
        };
      }
      this.editor.updateShapes([
        {
          id: this.shape.id,
          type: this.shape.type,
          props: {
            points
          }
        }
      ]);
    } else {
      const id = (0, import_editor.createShapeId)();
      this.markId = `creating:${id}`;
      this.editor.mark(this.markId);
      this.editor.createShapes([
        {
          id,
          type: "line",
          x: currentPagePoint.x,
          y: currentPagePoint.y,
          props: {
            scale: this.editor.user.getIsDynamicResizeMode() ? 1 / this.editor.getZoomLevel() : 1
          }
        }
      ]);
      this.editor.select(id);
      this.shape = this.editor.getShape(id);
    }
  };
  onPointerMove = () => {
    if (!this.shape) return;
    if (this.editor.inputs.isDragging) {
      const handles = this.editor.getShapeHandles(this.shape);
      if (!handles) {
        if (this.markId) this.editor.bailToMark(this.markId);
        throw Error("No handles found");
      }
      const lastHandle = (0, import_editor.last)(handles);
      this.editor.setCurrentTool("select.dragging_handle", {
        shape: this.shape,
        isCreating: true,
        // remove the offset that we added to the handle when we created it
        handle: { ...lastHandle, x: lastHandle.x - 0.1, y: lastHandle.y - 0.1 },
        onInteractionEnd: "line"
      });
    }
  };
  onPointerUp = () => {
    this.complete();
  };
  onCancel = () => {
    this.cancel();
  };
  onComplete = () => {
    this.complete();
  };
  onInterrupt = () => {
    this.parent.transition("idle");
    if (this.markId) this.editor.bailToMark(this.markId);
    this.editor.snaps.clearIndicators();
  };
  complete() {
    this.parent.transition("idle", { shapeId: this.shape.id });
    this.editor.snaps.clearIndicators();
  }
  cancel() {
    if (this.markId) this.editor.bailToMark(this.markId);
    this.parent.transition("idle", { shapeId: this.shape.id });
    this.editor.snaps.clearIndicators();
  }
}
//# sourceMappingURL=Pointing.js.map
