"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var useAsset_exports = {};
__export(useAsset_exports, {
  useAsset: () => useAsset
});
module.exports = __toCommonJS(useAsset_exports);
var import_editor = require("@tldraw/editor");
var import_react = require("react");
function useAsset(shapeId, assetId, width) {
  const editor = (0, import_editor.useEditor)();
  const [url, setUrl] = (0, import_react.useState)(null);
  const asset = assetId ? editor.getAsset(assetId) : null;
  const culledShapes = editor.getCulledShapes();
  const isCulled = culledShapes.has(shapeId);
  const didAlreadyResolve = (0, import_react.useRef)(false);
  (0, import_react.useEffect)(() => {
    if (url) didAlreadyResolve.current = true;
  }, [url]);
  const shapeScale = asset && "w" in asset.props ? width / asset.props.w : 1;
  const screenScale = (0, import_editor.useValue)("zoom level", () => editor.getZoomLevel() * shapeScale, [
    editor,
    shapeScale
  ]);
  (0, import_react.useEffect)(() => {
    if (isCulled) return;
    let isCancelled = false;
    const timer = editor.timers.setTimeout(
      async () => {
        const resolvedUrl = await editor.resolveAssetUrl(assetId, {
          screenScale
        });
        if (!isCancelled) setUrl(resolvedUrl);
      },
      didAlreadyResolve.current ? 500 : 0
    );
    return () => {
      clearTimeout(timer);
      isCancelled = true;
    };
  }, [assetId, asset?.props.src, isCulled, screenScale, editor]);
  return { asset, url };
}
//# sourceMappingURL=useAsset.js.map
