"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DefaultActionsMenu_exports = {};
__export(DefaultActionsMenu_exports, {
  DefaultActionsMenu: () => DefaultActionsMenu
});
module.exports = __toCommonJS(DefaultActionsMenu_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_react = require("react");
var import_constants = require("../../constants");
var import_breakpoints = require("../../context/breakpoints");
var import_useReadonly = require("../../hooks/useReadonly");
var import_useTranslation = require("../../hooks/useTranslation/useTranslation");
var import_TldrawUiButton = require("../primitives/Button/TldrawUiButton");
var import_TldrawUiButtonIcon = require("../primitives/Button/TldrawUiButtonIcon");
var import_TldrawUiPopover = require("../primitives/TldrawUiPopover");
var import_TldrawUiMenuContext = require("../primitives/menus/TldrawUiMenuContext");
var import_DefaultActionsMenuContent = require("./DefaultActionsMenuContent");
const DefaultActionsMenu = (0, import_react.memo)(function DefaultActionsMenu2({
  children
}) {
  const msg = (0, import_useTranslation.useTranslation)();
  const breakpoint = (0, import_breakpoints.useBreakpoint)();
  const isReadonlyMode = (0, import_useReadonly.useReadonly)();
  const editor = (0, import_editor.useEditor)();
  const isInAcceptableReadonlyState = (0, import_editor.useValue)(
    "should display quick actions when in readonly",
    () => editor.isInAny("hand", "zoom"),
    [editor]
  );
  const content = children ?? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_DefaultActionsMenuContent.DefaultActionsMenuContent, {});
  if (isReadonlyMode && !isInAcceptableReadonlyState) return;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiPopover.TldrawUiPopover, { id: "actions-menu", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiPopover.TldrawUiPopoverTrigger, { children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_TldrawUiButton.TldrawUiButton,
      {
        type: "icon",
        "data-testid": "actions-menu.button",
        title: msg("actions-menu.title"),
        children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiButtonIcon.TldrawUiButtonIcon, { icon: "dots-vertical", small: true })
      }
    ) }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_TldrawUiPopover.TldrawUiPopoverContent,
      {
        side: breakpoint >= import_constants.PORTRAIT_BREAKPOINT.TABLET ? "bottom" : "top",
        sideOffset: 6,
        children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tlui-actions-menu tlui-buttons__grid", "data-testid": "actions-menu.content", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuContext.TldrawUiMenuContextProvider, { type: "icons", sourceId: "actions-menu", children: content }) })
      }
    )
  ] });
});
//# sourceMappingURL=DefaultActionsMenu.js.map
