"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DefaultDebugPanel_exports = {};
__export(DefaultDebugPanel_exports, {
  DefaultDebugPanel: () => DefaultDebugPanel
});
module.exports = __toCommonJS(DefaultDebugPanel_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_react = require("react");
var import_components = require("../context/components");
const DefaultDebugPanel = (0, import_react.memo)(function DefaultDebugPanel2() {
  const { DebugMenu } = (0, import_components.useTldrawUiComponents)();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "tlui-debug-panel", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(CurrentState, {}),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(FPS, {}),
    DebugMenu && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DebugMenu, {})
  ] });
});
function useTick(isEnabled = true) {
  const [_, setTick] = (0, import_react.useState)(0);
  const editor = (0, import_editor.useEditor)();
  (0, import_react.useEffect)(() => {
    if (!isEnabled) return;
    const update = () => setTick((tick) => tick + 1);
    editor.on("tick", update);
    return () => {
      editor.off("tick", update);
    };
  }, [editor, isEnabled]);
}
const CurrentState = (0, import_editor.track)(function CurrentState2() {
  useTick();
  const editor = (0, import_editor.useEditor)();
  const path = editor.getPath();
  const hoverShape = editor.getHoveredShape();
  const selectedShape = editor.getOnlySelectedShape();
  const shape = path === "select.idle" || !path.includes("select.") ? hoverShape : selectedShape;
  const shapeInfo = shape && path.includes("select.") ? ` / ${shape.type || ""}${"geo" in shape.props ? " / " + shape.props.geo : ""} / [${import_editor.Vec.ToInt(editor.getPointInShapeSpace(shape, editor.inputs.currentPagePoint))}]` : "";
  const ruler = path.startsWith("select.") && !path.includes(".idle") ? ` / [${import_editor.Vec.ToInt(editor.inputs.originPagePoint)}] \u2192 [${import_editor.Vec.ToInt(
    editor.inputs.currentPagePoint
  )}] = ${import_editor.Vec.Dist(editor.inputs.originPagePoint, editor.inputs.currentPagePoint).toFixed(0)}` : "";
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tlui-debug-panel__current-state", children: `${path}${shapeInfo}${ruler}` });
});
function FPS() {
  const editor = (0, import_editor.useEditor)();
  const showFps = (0, import_editor.useValue)("show_fps", () => import_editor.debugFlags.showFps.get(), [import_editor.debugFlags]);
  const fpsRef = (0, import_react.useRef)(null);
  (0, import_react.useEffect)(() => {
    if (!showFps) return;
    const TICK_LENGTH = 250;
    let maxKnownFps = 0;
    let raf = -1;
    let start = performance.now();
    let currentTickLength = 0;
    let framesInCurrentTick = 0;
    let isSlow = false;
    function loop() {
      framesInCurrentTick++;
      currentTickLength = performance.now() - start;
      if (currentTickLength > TICK_LENGTH) {
        const fps = Math.round(
          framesInCurrentTick * (TICK_LENGTH / currentTickLength) * (1e3 / TICK_LENGTH)
        );
        if (fps > maxKnownFps) {
          maxKnownFps = fps;
        }
        const slowFps = maxKnownFps * 0.75;
        if (fps < slowFps && !isSlow || fps >= slowFps && isSlow) {
          isSlow = !isSlow;
        }
        fpsRef.current.innerHTML = `FPS ${fps.toString()}`;
        fpsRef.current.className = `tlui-debug-panel__fps` + (isSlow ? ` tlui-debug-panel__fps__slow` : ``);
        currentTickLength -= TICK_LENGTH;
        framesInCurrentTick = 0;
        start = performance.now();
      }
      raf = editor.timers.requestAnimationFrame(loop);
    }
    loop();
    return () => {
      cancelAnimationFrame(raf);
    };
  }, [showFps, editor]);
  if (!showFps) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { ref: fpsRef });
}
//# sourceMappingURL=DefaultDebugPanel.js.map
