"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var EditLinkDialog_exports = {};
__export(EditLinkDialog_exports, {
  EditLinkDialog: () => EditLinkDialog,
  EditLinkDialogInner: () => EditLinkDialogInner
});
module.exports = __toCommonJS(EditLinkDialog_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_react = require("react");
var import_useTranslation = require("../hooks/useTranslation/useTranslation");
var import_TldrawUiButton = require("./primitives/Button/TldrawUiButton");
var import_TldrawUiButtonLabel = require("./primitives/Button/TldrawUiButtonLabel");
var import_TldrawUiDialog = require("./primitives/TldrawUiDialog");
var import_TldrawUiInput = require("./primitives/TldrawUiInput");
function validateUrl(url) {
  if (import_editor.T.linkUrl.isValid(url)) {
    return { isValid: true, hasProtocol: true };
  }
  if (import_editor.T.linkUrl.isValid("https://" + url)) {
    return { isValid: true, hasProtocol: false };
  }
  return { isValid: false, hasProtocol: false };
}
const EditLinkDialog = (0, import_editor.track)(function EditLinkDialog2({ onClose }) {
  const editor = (0, import_editor.useEditor)();
  const selectedShape = editor.getOnlySelectedShape();
  if (!(selectedShape && "url" in selectedShape.props && typeof selectedShape.props.url === "string")) {
    return null;
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(EditLinkDialogInner, { onClose, selectedShape });
});
const EditLinkDialogInner = (0, import_editor.track)(function EditLinkDialogInner2({
  onClose,
  selectedShape
}) {
  const editor = (0, import_editor.useEditor)();
  const msg = (0, import_useTranslation.useTranslation)();
  const rInput = (0, import_react.useRef)(null);
  (0, import_react.useEffect)(() => {
    editor.timers.requestAnimationFrame(() => rInput.current?.focus());
  }, [editor]);
  const rInitialValue = (0, import_react.useRef)(selectedShape.props.url);
  const [urlInputState, setUrlInputState] = (0, import_react.useState)(() => {
    const urlValidResult = validateUrl(selectedShape.props.url);
    const initialValue = urlValidResult.isValid === true ? urlValidResult.hasProtocol ? selectedShape.props.url : "https://" + selectedShape.props.url : "https://";
    return {
      actual: initialValue,
      safe: initialValue,
      valid: true
    };
  });
  const handleChange = (0, import_react.useCallback)((rawValue) => {
    const fixedRawValue = rawValue.replace(/https?:\/\/(https?:\/\/)/, (_match, arg1) => {
      return arg1;
    });
    const urlValidResult = validateUrl(fixedRawValue);
    const safeValue = urlValidResult.isValid === true ? urlValidResult.hasProtocol ? fixedRawValue : "https://" + fixedRawValue : "https://";
    setUrlInputState({
      actual: fixedRawValue,
      safe: safeValue,
      valid: urlValidResult.isValid
    });
  }, []);
  const handleClear = (0, import_react.useCallback)(() => {
    const onlySelectedShape = editor.getOnlySelectedShape();
    if (!onlySelectedShape) return;
    editor.updateShapes([
      { id: onlySelectedShape.id, type: onlySelectedShape.type, props: { url: "" } }
    ]);
    onClose();
  }, [editor, onClose]);
  const handleComplete = (0, import_react.useCallback)(() => {
    const onlySelectedShape = editor.getOnlySelectedShape();
    if (!onlySelectedShape) return;
    if (onlySelectedShape && "url" in onlySelectedShape.props) {
      if (onlySelectedShape.props.url !== urlInputState.safe) {
        editor.updateShapes([
          {
            id: onlySelectedShape.id,
            type: onlySelectedShape.type,
            props: { url: urlInputState.safe }
          }
        ]);
      }
    }
    onClose();
  }, [editor, onClose, urlInputState]);
  const handleCancel = (0, import_react.useCallback)(() => {
    onClose();
  }, [onClose]);
  if (!selectedShape) {
    onClose();
    return null;
  }
  const isRemoving = rInitialValue.current && !urlInputState.valid;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_jsx_runtime.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiDialog.TldrawUiDialogHeader, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiDialog.TldrawUiDialogTitle, { children: msg("edit-link-dialog.title") }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiDialog.TldrawUiDialogCloseButton, {})
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiDialog.TldrawUiDialogBody, { children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "tlui-edit-link-dialog", children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        import_TldrawUiInput.TldrawUiInput,
        {
          ref: rInput,
          className: "tlui-edit-link-dialog__input",
          label: "edit-link-dialog.url",
          autoFocus: true,
          value: urlInputState.actual,
          onValueChange: handleChange,
          onComplete: handleComplete,
          onCancel: handleCancel
        }
      ),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { children: urlInputState.valid ? msg("edit-link-dialog.detail") : msg("edit-link-dialog.invalid-url") })
    ] }) }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiDialog.TldrawUiDialogFooter, { className: "tlui-dialog__footer__actions", children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiButton.TldrawUiButton, { type: "normal", onClick: handleCancel, onTouchEnd: handleCancel, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiButtonLabel.TldrawUiButtonLabel, { children: msg("edit-link-dialog.cancel") }) }),
      isRemoving ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiButton.TldrawUiButton, { type: "danger", onTouchEnd: handleClear, onClick: handleClear, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiButtonLabel.TldrawUiButtonLabel, { children: msg("edit-link-dialog.clear") }) }) : /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        import_TldrawUiButton.TldrawUiButton,
        {
          type: "primary",
          disabled: !urlInputState.valid,
          onTouchEnd: handleComplete,
          onClick: handleComplete,
          children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiButtonLabel.TldrawUiButtonLabel, { children: msg("edit-link-dialog.save") })
        }
      )
    ] })
  ] });
});
//# sourceMappingURL=EditLinkDialog.js.map
