"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp(target, key, result);
  return result;
};
var MinimapManager_exports = {};
__export(MinimapManager_exports, {
  MinimapManager: () => MinimapManager
});
module.exports = __toCommonJS(MinimapManager_exports);
var import_editor = require("@tldraw/editor");
var import_getRgba = require("./getRgba");
var import_minimap_webgl_setup = require("./minimap-webgl-setup");
var import_minimap_webgl_shapes = require("./minimap-webgl-shapes");
class MinimapManager {
  constructor(editor, elem, container) {
    this.editor = editor;
    this.elem = elem;
    this.container = container;
    this.gl = (0, import_minimap_webgl_setup.setupWebGl)(elem);
    this.shapeGeometryCache = editor.store.createComputedCache("webgl-geometry", (r) => {
      const bounds = editor.getShapeMaskedPageBounds(r.id);
      if (!bounds) return null;
      const arr = new Float32Array(12);
      (0, import_minimap_webgl_shapes.rectangle)(arr, 0, bounds.x, bounds.y, bounds.w, bounds.h);
      return arr;
    });
    this.colors = this._getColors();
    this.disposables.push(this._listenForCanvasResize(), (0, import_editor.react)("minimap render", this.render));
  }
  disposables = [];
  close = () => this.disposables.forEach((d) => d());
  gl;
  shapeGeometryCache;
  _getColors() {
    const style = getComputedStyle(this.editor.getContainer());
    return {
      shapeFill: (0, import_getRgba.getRgba)(style.getPropertyValue("--color-text-3").trim()),
      selectFill: (0, import_getRgba.getRgba)(style.getPropertyValue("--color-selected").trim()),
      viewportFill: (0, import_getRgba.getRgba)(style.getPropertyValue("--color-muted-1").trim()),
      background: (0, import_getRgba.getRgba)(style.getPropertyValue("--color-low").trim())
    };
  }
  colors;
  // this should be called after dark/light mode changes have propagated to the dom
  updateColors() {
    this.colors = this._getColors();
  }
  id = (0, import_editor.uniqueId)();
  getDpr() {
    return this.editor.getInstanceState().devicePixelRatio;
  }
  getContentPageBounds() {
    const viewportPageBounds = this.editor.getViewportPageBounds();
    const commonShapeBounds = this.editor.getCurrentPageBounds();
    return commonShapeBounds ? import_editor.Box.Expand(commonShapeBounds, viewportPageBounds) : viewportPageBounds;
  }
  getContentScreenBounds() {
    const contentPageBounds = this.getContentPageBounds();
    const topLeft = this.editor.pageToScreen(contentPageBounds.point);
    const bottomRight = this.editor.pageToScreen(
      new import_editor.Vec(contentPageBounds.maxX, contentPageBounds.maxY)
    );
    return new import_editor.Box(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
  }
  _getCanvasBoundingRect() {
    const { x, y, width, height } = this.elem.getBoundingClientRect();
    return new import_editor.Box(x, y, width, height);
  }
  canvasBoundingClientRect = (0, import_editor.atom)("canvasBoundingClientRect", new import_editor.Box());
  getCanvasScreenBounds() {
    return this.canvasBoundingClientRect.get();
  }
  _listenForCanvasResize() {
    const observer = new ResizeObserver(() => {
      const rect = this._getCanvasBoundingRect();
      this.canvasBoundingClientRect.set(rect);
    });
    observer.observe(this.elem);
    observer.observe(this.container);
    return () => observer.disconnect();
  }
  getCanvasSize() {
    const rect = this.canvasBoundingClientRect.get();
    const dpr = this.getDpr();
    return new import_editor.Vec(rect.width * dpr, rect.height * dpr);
  }
  getCanvasClientPosition() {
    return this.canvasBoundingClientRect.get().point;
  }
  originPagePoint = new import_editor.Vec();
  originPageCenter = new import_editor.Vec();
  isInViewport = false;
  getCanvasPageBounds() {
    const canvasScreenBounds = this.getCanvasScreenBounds();
    const contentPageBounds = this.getContentPageBounds();
    const aspectRatio = canvasScreenBounds.width / canvasScreenBounds.height;
    let targetWidth = contentPageBounds.width;
    let targetHeight = targetWidth / aspectRatio;
    if (targetHeight < contentPageBounds.height) {
      targetHeight = contentPageBounds.height;
      targetWidth = targetHeight * aspectRatio;
    }
    const box = new import_editor.Box(0, 0, targetWidth, targetHeight);
    box.center = contentPageBounds.center;
    return box;
  }
  getZoom() {
    return this.getCanvasPageBounds().width / this.getCanvasScreenBounds().width;
  }
  getCanvasPageBoundsArray() {
    const { x, y, w, h } = this.getCanvasPageBounds();
    return new Float32Array([x, y, w, h]);
  }
  getMinimapPagePoint = (clientX, clientY) => {
    const canvasPageBounds = this.getCanvasPageBounds();
    const canvasScreenBounds = this.getCanvasScreenBounds();
    let x = clientX - canvasScreenBounds.x;
    let y = clientY - canvasScreenBounds.y;
    x *= canvasPageBounds.width / canvasScreenBounds.width;
    y *= canvasPageBounds.height / canvasScreenBounds.height;
    x += canvasPageBounds.minX;
    y += canvasPageBounds.minY;
    return new import_editor.Vec(x, y, 1);
  };
  minimapScreenPointToPagePoint = (x, y, shiftKey = false, clampToBounds = false) => {
    const { editor } = this;
    const vpPageBounds = editor.getViewportPageBounds();
    let { x: px, y: py } = this.getMinimapPagePoint(x, y);
    if (clampToBounds) {
      const shapesPageBounds = this.editor.getCurrentPageBounds() ?? new import_editor.Box();
      const minX = shapesPageBounds.minX - vpPageBounds.width / 2;
      const maxX = shapesPageBounds.maxX + vpPageBounds.width / 2;
      const minY = shapesPageBounds.minY - vpPageBounds.height / 2;
      const maxY = shapesPageBounds.maxY + vpPageBounds.height / 2;
      const lx = Math.max(0, minX + vpPageBounds.width - px);
      const rx = Math.max(0, -(maxX - vpPageBounds.width - px));
      const ly = Math.max(0, minY + vpPageBounds.height - py);
      const ry = Math.max(0, -(maxY - vpPageBounds.height - py));
      px += (lx - rx) / 2;
      py += (ly - ry) / 2;
      px = (0, import_editor.clamp)(px, minX, maxX);
      py = (0, import_editor.clamp)(py, minY, maxY);
    }
    if (shiftKey) {
      const { originPagePoint } = this;
      const dx = Math.abs(px - originPagePoint.x);
      const dy = Math.abs(py - originPagePoint.y);
      if (dx > dy) {
        py = originPagePoint.y;
      } else {
        px = originPagePoint.x;
      }
    }
    return new import_editor.Vec(px, py);
  };
  render = () => {
    const context = this.gl.context;
    const canvasSize = this.getCanvasSize();
    this.gl.setCanvasPageBounds(this.getCanvasPageBoundsArray());
    this.elem.width = canvasSize.x;
    this.elem.height = canvasSize.y;
    context.viewport(0, 0, canvasSize.x, canvasSize.y);
    context.clearColor(
      this.colors.background[0],
      this.colors.background[1],
      this.colors.background[2],
      1
    );
    context.clear(context.COLOR_BUFFER_BIT);
    const selectedShapes = new Set(this.editor.getSelectedShapeIds());
    const colors = this.colors;
    let selectedShapeOffset = 0;
    let unselectedShapeOffset = 0;
    const ids = this.editor.getCurrentPageShapeIdsSorted();
    for (let i = 0, len = ids.length; i < len; i++) {
      const shapeId = ids[i];
      const geometry = this.shapeGeometryCache.get(shapeId);
      if (!geometry) continue;
      const len2 = geometry.length;
      if (selectedShapes.has(shapeId)) {
        (0, import_minimap_webgl_setup.appendVertices)(this.gl.selectedShapes, selectedShapeOffset, geometry);
        selectedShapeOffset += len2;
      } else {
        (0, import_minimap_webgl_setup.appendVertices)(this.gl.unselectedShapes, unselectedShapeOffset, geometry);
        unselectedShapeOffset += len2;
      }
    }
    this.drawShapes(this.gl.unselectedShapes, unselectedShapeOffset, colors.shapeFill);
    this.drawShapes(this.gl.selectedShapes, selectedShapeOffset, colors.selectFill);
    this.drawViewport();
    this.drawCollaborators();
  };
  drawShapes(stuff, len, color) {
    this.gl.prepareTriangles(stuff, len);
    this.gl.setFillColor(color);
    this.gl.drawTriangles(len);
  }
  drawViewport() {
    const viewport = this.editor.getViewportPageBounds();
    const len = (0, import_minimap_webgl_shapes.roundedRectangle)(this.gl.viewport.vertices, viewport, 4 * this.getZoom());
    this.gl.prepareTriangles(this.gl.viewport, len);
    this.gl.setFillColor(this.colors.viewportFill);
    this.gl.drawTrianglesTransparently(len);
    if (this.editor.environment.isSafari) {
      this.gl.drawTrianglesTransparently(len);
      this.gl.drawTrianglesTransparently(len);
      this.gl.drawTrianglesTransparently(len);
    }
  }
  drawCollaborators() {
    const collaborators = this.editor.getCollaboratorsOnCurrentPage();
    if (!collaborators.length) return;
    const numSegmentsPerCircle = 20;
    const dataSizePerCircle = numSegmentsPerCircle * 6;
    const totalSize = dataSizePerCircle * collaborators.length;
    if (this.gl.collaborators.vertices.length < totalSize) {
      this.gl.collaborators.vertices = new Float32Array(totalSize);
    }
    const vertices = this.gl.collaborators.vertices;
    let offset = 0;
    const zoom = this.getZoom();
    for (const { cursor } of collaborators) {
      (0, import_minimap_webgl_shapes.pie)(vertices, {
        center: import_editor.Vec.From(cursor),
        radius: 3 * zoom,
        offset,
        numArcSegments: numSegmentsPerCircle
      });
      offset += dataSizePerCircle;
    }
    this.gl.prepareTriangles(this.gl.collaborators, totalSize);
    offset = 0;
    for (const { color } of collaborators) {
      this.gl.setFillColor((0, import_getRgba.getRgba)(color));
      this.gl.context.drawArrays(this.gl.context.TRIANGLES, offset / 2, dataSizePerCircle / 2);
      offset += dataSizePerCircle;
    }
  }
}
__decorateClass([
  import_editor.computed
], MinimapManager.prototype, "getDpr", 1);
__decorateClass([
  import_editor.computed
], MinimapManager.prototype, "getContentPageBounds", 1);
__decorateClass([
  import_editor.computed
], MinimapManager.prototype, "getContentScreenBounds", 1);
__decorateClass([
  import_editor.computed
], MinimapManager.prototype, "getCanvasSize", 1);
__decorateClass([
  import_editor.computed
], MinimapManager.prototype, "getCanvasClientPosition", 1);
__decorateClass([
  import_editor.computed
], MinimapManager.prototype, "getCanvasPageBounds", 1);
__decorateClass([
  import_editor.computed
], MinimapManager.prototype, "getZoom", 1);
__decorateClass([
  import_editor.computed
], MinimapManager.prototype, "getCanvasPageBoundsArray", 1);
//# sourceMappingURL=MinimapManager.js.map
