"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var menu_items_exports = {};
__export(menu_items_exports, {
  ArrangeMenuSubmenu: () => ArrangeMenuSubmenu,
  ClipboardMenuGroup: () => ClipboardMenuGroup,
  ConversionsMenuGroup: () => ConversionsMenuGroup,
  ConvertToBookmarkMenuItem: () => ConvertToBookmarkMenuItem,
  ConvertToEmbedMenuItem: () => ConvertToEmbedMenuItem,
  CopyAsMenuGroup: () => CopyAsMenuGroup,
  CopyMenuItem: () => CopyMenuItem,
  CursorChatItem: () => CursorChatItem,
  CutMenuItem: () => CutMenuItem,
  DeleteMenuItem: () => DeleteMenuItem,
  DuplicateMenuItem: () => DuplicateMenuItem,
  EditLinkMenuItem: () => EditLinkMenuItem,
  EditMenuSubmenu: () => EditMenuSubmenu,
  FitFrameToContentMenuItem: () => FitFrameToContentMenuItem,
  FlattenMenuItem: () => FlattenMenuItem,
  GroupMenuItem: () => GroupMenuItem,
  MoveToPageMenu: () => MoveToPageMenu,
  PasteMenuItem: () => PasteMenuItem,
  PrintItem: () => PrintItem,
  RemoveFrameMenuItem: () => RemoveFrameMenuItem,
  ReorderMenuSubmenu: () => ReorderMenuSubmenu,
  SelectAllMenuItem: () => SelectAllMenuItem,
  ToggleAutoSizeMenuItem: () => ToggleAutoSizeMenuItem,
  ToggleDarkModeItem: () => ToggleDarkModeItem,
  ToggleDebugModeItem: () => ToggleDebugModeItem,
  ToggleDynamicSizeModeItem: () => ToggleDynamicSizeModeItem,
  ToggleEdgeScrollingItem: () => ToggleEdgeScrollingItem,
  ToggleFocusModeItem: () => ToggleFocusModeItem,
  ToggleGridItem: () => ToggleGridItem,
  ToggleLockMenuItem: () => ToggleLockMenuItem,
  TogglePasteAtCursorItem: () => TogglePasteAtCursorItem,
  ToggleReduceMotionItem: () => ToggleReduceMotionItem,
  ToggleSnapModeItem: () => ToggleSnapModeItem,
  ToggleToolLockItem: () => ToggleToolLockItem,
  ToggleTransparentBgMenuItem: () => ToggleTransparentBgMenuItem,
  ToggleWrapModeItem: () => ToggleWrapModeItem,
  UngroupMenuItem: () => UngroupMenuItem,
  UnlockAllMenuItem: () => UnlockAllMenuItem,
  ZoomTo100MenuItem: () => ZoomTo100MenuItem,
  ZoomToFitMenuItem: () => ZoomToFitMenuItem,
  ZoomToSelectionMenuItem: () => ZoomToSelectionMenuItem
});
module.exports = __toCommonJS(menu_items_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_embeds = require("../../utils/embeds/embeds");
var import_actions = require("../context/actions");
var import_events = require("../context/events");
var import_toasts = require("../context/toasts");
var import_menu_hooks = require("../hooks/menu-hooks");
var import_TldrawUiMenuCheckboxItem = require("./primitives/menus/TldrawUiMenuCheckboxItem");
var import_TldrawUiMenuGroup = require("./primitives/menus/TldrawUiMenuGroup");
var import_TldrawUiMenuItem = require("./primitives/menus/TldrawUiMenuItem");
var import_TldrawUiMenuSubmenu = require("./primitives/menus/TldrawUiMenuSubmenu");
function ToggleAutoSizeMenuItem() {
  const actions = (0, import_actions.useActions)();
  const shouldDisplay = (0, import_menu_hooks.useShowAutoSizeToggle)();
  if (!shouldDisplay) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["toggle-auto-size"] });
}
function EditLinkMenuItem() {
  const actions = (0, import_actions.useActions)();
  const shouldDisplay = (0, import_menu_hooks.useHasLinkShapeSelected)();
  if (!shouldDisplay) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["edit-link"] });
}
function DuplicateMenuItem() {
  const actions = (0, import_actions.useActions)();
  const shouldDisplay = (0, import_menu_hooks.useUnlockedSelectedShapesCount)(1);
  if (!shouldDisplay) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["duplicate"] });
}
function FlattenMenuItem() {
  const actions = (0, import_actions.useActions)();
  const editor = (0, import_editor.useEditor)();
  const shouldDisplay = (0, import_editor.useValue)(
    "should display flatten option",
    () => {
      const selectedShapeIds = editor.getSelectedShapeIds();
      if (selectedShapeIds.length === 0) return false;
      const onlySelectedShape = editor.getOnlySelectedShape();
      if (onlySelectedShape && editor.isShapeOfType(onlySelectedShape, "image")) {
        return false;
      }
      return true;
    },
    [editor]
  );
  if (!shouldDisplay) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["flatten-to-image"] });
}
function GroupMenuItem() {
  const actions = (0, import_actions.useActions)();
  const shouldDisplay = (0, import_menu_hooks.useAllowGroup)();
  if (!shouldDisplay) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["group"] });
}
function UngroupMenuItem() {
  const actions = (0, import_actions.useActions)();
  const shouldDisplay = (0, import_menu_hooks.useAllowUngroup)();
  if (!shouldDisplay) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["ungroup"] });
}
function RemoveFrameMenuItem() {
  const editor = (0, import_editor.useEditor)();
  const actions = (0, import_actions.useActions)();
  const shouldDisplay = (0, import_editor.useValue)(
    "allow unframe",
    () => {
      const selectedShapes = editor.getSelectedShapes();
      if (selectedShapes.length === 0) return false;
      return selectedShapes.every((shape) => editor.isShapeOfType(shape, "frame"));
    },
    [editor]
  );
  if (!shouldDisplay) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["remove-frame"] });
}
function FitFrameToContentMenuItem() {
  const editor = (0, import_editor.useEditor)();
  const actions = (0, import_actions.useActions)();
  const shouldDisplay = (0, import_editor.useValue)(
    "allow fit frame to content",
    () => {
      const onlySelectedShape = editor.getOnlySelectedShape();
      if (!onlySelectedShape) return false;
      return editor.isShapeOfType(onlySelectedShape, "frame") && editor.getSortedChildIdsForParent(onlySelectedShape).length > 0;
    },
    [editor]
  );
  if (!shouldDisplay) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["fit-frame-to-content"] });
}
function ToggleLockMenuItem() {
  const editor = (0, import_editor.useEditor)();
  const actions = (0, import_actions.useActions)();
  const shouldDisplay = (0, import_editor.useValue)("selected shapes", () => editor.getSelectedShapes().length > 0, [
    editor
  ]);
  if (!shouldDisplay) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["toggle-lock"] });
}
function ToggleTransparentBgMenuItem() {
  const actions = (0, import_actions.useActions)();
  const editor = (0, import_editor.useEditor)();
  const isTransparentBg = (0, import_editor.useValue)(
    "isTransparentBg",
    () => !editor.getInstanceState().exportBackground,
    [editor]
  );
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuCheckboxItem.TldrawUiMenuCheckboxItem, { ...actions["toggle-transparent"], checked: isTransparentBg, toggle: true });
}
function UnlockAllMenuItem() {
  const editor = (0, import_editor.useEditor)();
  const actions = (0, import_actions.useActions)();
  const shouldDisplay = (0, import_editor.useValue)("any shapes", () => editor.getCurrentPageShapeIds().size > 0, [
    editor
  ]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["unlock-all"], disabled: !shouldDisplay });
}
function ZoomTo100MenuItem() {
  const editor = (0, import_editor.useEditor)();
  const isZoomedTo100 = (0, import_editor.useValue)("zoomed to 100", () => editor.getZoomLevel() === 1, [editor]);
  const actions = (0, import_actions.useActions)();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["zoom-to-100"], noClose: true, disabled: isZoomedTo100 });
}
function ZoomToFitMenuItem() {
  const editor = (0, import_editor.useEditor)();
  const hasShapes = (0, import_editor.useValue)("has shapes", () => editor.getCurrentPageShapeIds().size > 0, [editor]);
  const actions = (0, import_actions.useActions)();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_TldrawUiMenuItem.TldrawUiMenuItem,
    {
      ...actions["zoom-to-fit"],
      disabled: !hasShapes,
      "data-testid": "minimap.zoom-menu.zoom-to-fit",
      noClose: true
    }
  );
}
function ZoomToSelectionMenuItem() {
  const editor = (0, import_editor.useEditor)();
  const hasSelected = (0, import_editor.useValue)("has shapes", () => editor.getSelectedShapeIds().length > 0, [
    editor
  ]);
  const actions = (0, import_actions.useActions)();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_TldrawUiMenuItem.TldrawUiMenuItem,
    {
      ...actions["zoom-to-selection"],
      disabled: !hasSelected,
      "data-testid": "minimap.zoom-menu.zoom-to-selection",
      noClose: true
    }
  );
}
function ClipboardMenuGroup() {
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiMenuGroup.TldrawUiMenuGroup, { id: "clipboard", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(CutMenuItem, {}),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(CopyMenuItem, {}),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(PasteMenuItem, {}),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DuplicateMenuItem, {}),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DeleteMenuItem, {})
  ] });
}
function CopyAsMenuGroup() {
  const editor = (0, import_editor.useEditor)();
  const actions = (0, import_actions.useActions)();
  const atLeastOneShapeOnPage = (0, import_editor.useValue)(
    "atLeastOneShapeOnPage",
    () => editor.getCurrentPageShapeIds().size > 0,
    [editor]
  );
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
    import_TldrawUiMenuSubmenu.TldrawUiMenuSubmenu,
    {
      id: "copy-as",
      label: "context-menu.copy-as",
      size: "small",
      disabled: !atLeastOneShapeOnPage,
      children: [
        /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiMenuGroup.TldrawUiMenuGroup, { id: "copy-as-group", children: [
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["copy-as-svg"] }),
          Boolean(window.navigator.clipboard?.write) && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["copy-as-png"] }),
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["copy-as-json"] })
        ] }),
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuGroup.TldrawUiMenuGroup, { id: "copy-as-bg", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(ToggleTransparentBgMenuItem, {}) })
      ]
    }
  );
}
function CutMenuItem() {
  const actions = (0, import_actions.useActions)();
  const shouldDisplay = (0, import_menu_hooks.useUnlockedSelectedShapesCount)(1);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["cut"], disabled: !shouldDisplay });
}
function CopyMenuItem() {
  const actions = (0, import_actions.useActions)();
  const shouldDisplay = (0, import_menu_hooks.useAnySelectedShapesCount)(1);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["copy"], disabled: !shouldDisplay });
}
function PasteMenuItem() {
  const actions = (0, import_actions.useActions)();
  const shouldDisplay = import_menu_hooks.showMenuPaste;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["paste"], disabled: !shouldDisplay });
}
function ConversionsMenuGroup() {
  const editor = (0, import_editor.useEditor)();
  const actions = (0, import_actions.useActions)();
  const atLeastOneShapeOnPage = (0, import_editor.useValue)(
    "atLeastOneShapeOnPage",
    () => editor.getCurrentPageShapeIds().size > 0,
    [editor]
  );
  if (!atLeastOneShapeOnPage) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiMenuGroup.TldrawUiMenuGroup, { id: "conversions", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(CopyAsMenuGroup, {}),
    /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiMenuSubmenu.TldrawUiMenuSubmenu, { id: "export-as", label: "context-menu.export-as", size: "small", children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiMenuGroup.TldrawUiMenuGroup, { id: "export-as-group", children: [
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["export-as-svg"] }),
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["export-as-png"] }),
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["export-as-json"] })
      ] }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuGroup.TldrawUiMenuGroup, { id: "export-as-bg", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(ToggleTransparentBgMenuItem, {}) })
    ] })
  ] });
}
function SelectAllMenuItem() {
  const actions = (0, import_actions.useActions)();
  const editor = (0, import_editor.useEditor)();
  const atLeastOneShapeOnPage = (0, import_editor.useValue)(
    "atLeastOneShapeOnPage",
    () => editor.getCurrentPageShapeIds().size > 0,
    [editor]
  );
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["select-all"], disabled: !atLeastOneShapeOnPage });
}
function DeleteMenuItem() {
  const actions = (0, import_actions.useActions)();
  const oneSelected = (0, import_menu_hooks.useUnlockedSelectedShapesCount)(1);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["delete"], disabled: !oneSelected });
}
function EditMenuSubmenu() {
  if (!(0, import_menu_hooks.useAnySelectedShapesCount)(1)) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiMenuSubmenu.TldrawUiMenuSubmenu, { id: "edit", label: "context-menu.edit", size: "small", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(GroupMenuItem, {}),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(UngroupMenuItem, {}),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(FlattenMenuItem, {}),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(EditLinkMenuItem, {}),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(FitFrameToContentMenuItem, {}),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(RemoveFrameMenuItem, {}),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(ConvertToEmbedMenuItem, {}),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(ConvertToBookmarkMenuItem, {}),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(ToggleAutoSizeMenuItem, {}),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(ToggleLockMenuItem, {})
  ] });
}
function ArrangeMenuSubmenu() {
  const twoSelected = (0, import_menu_hooks.useUnlockedSelectedShapesCount)(2);
  const onlyFlippableShapeSelected = (0, import_menu_hooks.useOnlyFlippableShape)();
  const actions = (0, import_actions.useActions)();
  if (!(twoSelected || onlyFlippableShapeSelected)) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiMenuSubmenu.TldrawUiMenuSubmenu, { id: "arrange", label: "context-menu.arrange", size: "small", children: [
    twoSelected && /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiMenuGroup.TldrawUiMenuGroup, { id: "align", children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["align-left"] }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["align-center-horizontal"] }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["align-right"] }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["align-top"] }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["align-center-vertical"] }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["align-bottom"] })
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DistributeMenuGroup, {}),
    twoSelected && /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiMenuGroup.TldrawUiMenuGroup, { id: "stretch", children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["stretch-horizontal"] }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["stretch-vertical"] })
    ] }),
    (twoSelected || onlyFlippableShapeSelected) && /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiMenuGroup.TldrawUiMenuGroup, { id: "flip", children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["flip-horizontal"] }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["flip-vertical"] })
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(OrderMenuGroup, {})
  ] });
}
function DistributeMenuGroup() {
  const actions = (0, import_actions.useActions)();
  const threeSelected = (0, import_menu_hooks.useUnlockedSelectedShapesCount)(3);
  if (!threeSelected) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiMenuGroup.TldrawUiMenuGroup, { id: "distribute", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["distribute-horizontal"] }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["distribute-vertical"] })
  ] });
}
function OrderMenuGroup() {
  const actions = (0, import_actions.useActions)();
  const twoSelected = (0, import_menu_hooks.useUnlockedSelectedShapesCount)(2);
  const threeStackableItems = (0, import_menu_hooks.useThreeStackableItems)();
  if (!twoSelected) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiMenuGroup.TldrawUiMenuGroup, { id: "order", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["pack"] }),
    threeStackableItems && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["stack-horizontal"] }),
    threeStackableItems && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["stack-vertical"] })
  ] });
}
function ReorderMenuSubmenu() {
  const actions = (0, import_actions.useActions)();
  const oneSelected = (0, import_menu_hooks.useUnlockedSelectedShapesCount)(1);
  if (!oneSelected) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuSubmenu.TldrawUiMenuSubmenu, { id: "reorder", label: "context-menu.reorder", size: "small", children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiMenuGroup.TldrawUiMenuGroup, { id: "reorder", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["bring-to-front"] }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["bring-forward"] }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["send-backward"] }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["send-to-back"] })
  ] }) });
}
function MoveToPageMenu() {
  const editor = (0, import_editor.useEditor)();
  const pages = (0, import_editor.useValue)("pages", () => editor.getPages(), [editor]);
  const currentPageId = (0, import_editor.useValue)("current page id", () => editor.getCurrentPageId(), [editor]);
  const { addToast } = (0, import_toasts.useToasts)();
  const actions = (0, import_actions.useActions)();
  const trackEvent = (0, import_events.useUiEvents)();
  const oneSelected = (0, import_menu_hooks.useUnlockedSelectedShapesCount)(1);
  if (!oneSelected) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_TldrawUiMenuSubmenu.TldrawUiMenuSubmenu, { id: "move-to-page", label: "context-menu.move-to-page", size: "small", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuGroup.TldrawUiMenuGroup, { id: "pages", children: pages.map((page) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_TldrawUiMenuItem.TldrawUiMenuItem,
      {
        id: page.id,
        disabled: currentPageId === page.id,
        label: page.name,
        onSelect: () => {
          editor.mark("move_shapes_to_page");
          editor.moveShapesToPage(editor.getSelectedShapeIds(), page.id);
          const toPage = editor.getPage(page.id);
          if (toPage) {
            addToast({
              title: "Changed Page",
              description: `Moved to ${toPage.name}.`,
              actions: [
                {
                  label: "Go Back",
                  type: "primary",
                  onClick: () => {
                    editor.mark("change-page");
                    editor.setCurrentPage(currentPageId);
                  }
                }
              ]
            });
          }
          trackEvent("move-to-page", { source: "context-menu" });
        }
      },
      page.id
    )) }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuGroup.TldrawUiMenuGroup, { id: "new-page", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["move-to-new-page"] }) })
  ] });
}
function ConvertToBookmarkMenuItem() {
  const editor = (0, import_editor.useEditor)();
  const actions = (0, import_actions.useActions)();
  const oneEmbedSelected = (0, import_editor.useValue)(
    "oneEmbedSelected",
    () => {
      const onlySelectedShape = editor.getOnlySelectedShape();
      if (!onlySelectedShape) return false;
      return !!(editor.isShapeOfType(onlySelectedShape, "embed") && onlySelectedShape.props.url && !editor.isShapeOrAncestorLocked(onlySelectedShape));
    },
    [editor]
  );
  if (!oneEmbedSelected) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["convert-to-bookmark"] });
}
function ConvertToEmbedMenuItem() {
  const editor = (0, import_editor.useEditor)();
  const actions = (0, import_actions.useActions)();
  const oneEmbeddableBookmarkSelected = (0, import_editor.useValue)(
    "oneEmbeddableBookmarkSelected",
    () => {
      const onlySelectedShape = editor.getOnlySelectedShape();
      if (!onlySelectedShape) return false;
      return !!(editor.isShapeOfType(onlySelectedShape, "bookmark") && onlySelectedShape.props.url && (0, import_embeds.getEmbedInfo)(onlySelectedShape.props.url) && !editor.isShapeOrAncestorLocked(onlySelectedShape));
    },
    [editor]
  );
  if (!oneEmbeddableBookmarkSelected) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["convert-to-embed"] });
}
function ToggleSnapModeItem() {
  const actions = (0, import_actions.useActions)();
  const editor = (0, import_editor.useEditor)();
  const isSnapMode = (0, import_editor.useValue)("isSnapMode", () => editor.user.getIsSnapMode(), [editor]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuCheckboxItem.TldrawUiMenuCheckboxItem, { ...actions["toggle-snap-mode"], checked: isSnapMode });
}
function ToggleToolLockItem() {
  const actions = (0, import_actions.useActions)();
  const editor = (0, import_editor.useEditor)();
  const isToolLock = (0, import_editor.useValue)("isToolLock", () => editor.getInstanceState().isToolLocked, [editor]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuCheckboxItem.TldrawUiMenuCheckboxItem, { ...actions["toggle-tool-lock"], checked: isToolLock });
}
function ToggleGridItem() {
  const actions = (0, import_actions.useActions)();
  const editor = (0, import_editor.useEditor)();
  const isGridMode = (0, import_editor.useValue)("isGridMode", () => editor.getInstanceState().isGridMode, [editor]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuCheckboxItem.TldrawUiMenuCheckboxItem, { ...actions["toggle-grid"], checked: isGridMode });
}
function ToggleWrapModeItem() {
  const actions = (0, import_actions.useActions)();
  const editor = (0, import_editor.useEditor)();
  const isWrapMode = (0, import_editor.useValue)("isWrapMode", () => editor.user.getIsWrapMode(), [editor]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuCheckboxItem.TldrawUiMenuCheckboxItem, { ...actions["toggle-wrap-mode"], checked: isWrapMode });
}
function ToggleDarkModeItem() {
  const actions = (0, import_actions.useActions)();
  const editor = (0, import_editor.useEditor)();
  const isDarkMode = (0, import_editor.useValue)("isDarkMode", () => editor.user.getIsDarkMode(), [editor]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuCheckboxItem.TldrawUiMenuCheckboxItem, { ...actions["toggle-dark-mode"], checked: isDarkMode });
}
function ToggleFocusModeItem() {
  const actions = (0, import_actions.useActions)();
  const editor = (0, import_editor.useEditor)();
  const isFocusMode = (0, import_editor.useValue)("isFocusMode", () => editor.getInstanceState().isFocusMode, [editor]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuCheckboxItem.TldrawUiMenuCheckboxItem, { ...actions["toggle-focus-mode"], checked: isFocusMode });
}
function ToggleEdgeScrollingItem() {
  const actions = (0, import_actions.useActions)();
  const editor = (0, import_editor.useEditor)();
  const edgeScrollSpeed = (0, import_editor.useValue)("edgeScrollSpeed", () => editor.user.getEdgeScrollSpeed(), [
    editor
  ]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_TldrawUiMenuCheckboxItem.TldrawUiMenuCheckboxItem,
    {
      ...actions["toggle-edge-scrolling"],
      checked: edgeScrollSpeed === 1
    }
  );
}
function ToggleReduceMotionItem() {
  const actions = (0, import_actions.useActions)();
  const editor = (0, import_editor.useEditor)();
  const animationSpeed = (0, import_editor.useValue)("animationSpeed", () => editor.user.getAnimationSpeed(), [editor]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuCheckboxItem.TldrawUiMenuCheckboxItem, { ...actions["toggle-reduce-motion"], checked: animationSpeed === 0 });
}
function ToggleDebugModeItem() {
  const actions = (0, import_actions.useActions)();
  const editor = (0, import_editor.useEditor)();
  const isDebugMode = (0, import_editor.useValue)("isDebugMode", () => editor.getInstanceState().isDebugMode, [editor]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuCheckboxItem.TldrawUiMenuCheckboxItem, { ...actions["toggle-debug-mode"], checked: isDebugMode });
}
function ToggleDynamicSizeModeItem() {
  const actions = (0, import_actions.useActions)();
  const editor = (0, import_editor.useEditor)();
  const isDynamicResizeMode = (0, import_editor.useValue)(
    "dynamic resize",
    () => editor.user.getIsDynamicResizeMode(),
    [editor]
  );
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_TldrawUiMenuCheckboxItem.TldrawUiMenuCheckboxItem,
    {
      ...actions["toggle-dynamic-size-mode"],
      checked: isDynamicResizeMode
    }
  );
}
function TogglePasteAtCursorItem() {
  const actions = (0, import_actions.useActions)();
  const editor = (0, import_editor.useEditor)();
  const pasteAtCursor = (0, import_editor.useValue)("paste at cursor", () => editor.user.getIsPasteAtCursorMode(), [
    editor
  ]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuCheckboxItem.TldrawUiMenuCheckboxItem, { ...actions["toggle-paste-at-cursor"], checked: pasteAtCursor });
}
function PrintItem() {
  const editor = (0, import_editor.useEditor)();
  const actions = (0, import_actions.useActions)();
  const emptyPage = (0, import_editor.useValue)("emptyPage", () => editor.getCurrentPageShapeIds().size === 0, [
    editor
  ]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["print"], disabled: emptyPage });
}
function CursorChatItem() {
  const editor = (0, import_editor.useEditor)();
  const actions = (0, import_actions.useActions)();
  const shouldShow = (0, import_editor.useValue)(
    "show cursor chat",
    () => editor.getCurrentToolId() === "select" && !editor.getInstanceState().isCoarsePointer,
    [editor]
  );
  if (!shouldShow) return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuItem.TldrawUiMenuItem, { ...actions["open-cursor-chat"] });
}
//# sourceMappingURL=menu-items.js.map
