"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var TldrawUiDropdownMenu_exports = {};
__export(TldrawUiDropdownMenu_exports, {
  TldrawUiDropdownMenuCheckboxItem: () => TldrawUiDropdownMenuCheckboxItem,
  TldrawUiDropdownMenuContent: () => TldrawUiDropdownMenuContent,
  TldrawUiDropdownMenuGroup: () => TldrawUiDropdownMenuGroup,
  TldrawUiDropdownMenuIndicator: () => TldrawUiDropdownMenuIndicator,
  TldrawUiDropdownMenuItem: () => TldrawUiDropdownMenuItem,
  TldrawUiDropdownMenuRoot: () => TldrawUiDropdownMenuRoot,
  TldrawUiDropdownMenuSub: () => TldrawUiDropdownMenuSub,
  TldrawUiDropdownMenuSubContent: () => TldrawUiDropdownMenuSubContent,
  TldrawUiDropdownMenuSubTrigger: () => TldrawUiDropdownMenuSubTrigger,
  TldrawUiDropdownMenuTrigger: () => TldrawUiDropdownMenuTrigger
});
module.exports = __toCommonJS(TldrawUiDropdownMenu_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var _DropdownMenu = __toESM(require("@radix-ui/react-dropdown-menu"));
var import_editor = require("@tldraw/editor");
var import_useMenuIsOpen = require("../../hooks/useMenuIsOpen");
var import_TldrawUiButton = require("./Button/TldrawUiButton");
var import_TldrawUiButtonIcon = require("./Button/TldrawUiButtonIcon");
var import_TldrawUiButtonLabel = require("./Button/TldrawUiButtonLabel");
var import_TldrawUiIcon = require("./TldrawUiIcon");
function TldrawUiDropdownMenuRoot({
  id,
  children,
  modal = false,
  debugOpen = false
}) {
  const [open, onOpenChange] = (0, import_useMenuIsOpen.useMenuIsOpen)(id);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    _DropdownMenu.Root,
    {
      open: debugOpen || open,
      dir: "ltr",
      modal,
      onOpenChange,
      children
    }
  );
}
function TldrawUiDropdownMenuTrigger({ children, ...rest }) {
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    _DropdownMenu.Trigger,
    {
      dir: "ltr",
      asChild: true,
      onTouchEnd: (e) => (0, import_editor.preventDefault)(e),
      ...rest,
      children
    }
  );
}
function TldrawUiDropdownMenuContent({
  side = "bottom",
  align = "start",
  sideOffset = 8,
  alignOffset = 8,
  children
}) {
  const container = (0, import_editor.useContainer)();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(_DropdownMenu.Portal, { container, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    _DropdownMenu.Content,
    {
      className: "tlui-menu",
      side,
      sideOffset,
      align,
      alignOffset,
      collisionPadding: 4,
      children
    }
  ) });
}
function TldrawUiDropdownMenuSub({ id, children }) {
  const [open, onOpenChange] = (0, import_useMenuIsOpen.useMenuIsOpen)(id);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(_DropdownMenu.Sub, { open, onOpenChange, children });
}
function TldrawUiDropdownMenuSubTrigger({
  id,
  label,
  title,
  disabled
}) {
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(_DropdownMenu.SubTrigger, { dir: "ltr", asChild: true, disabled, children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
    import_TldrawUiButton.TldrawUiButton,
    {
      "data-testid": id,
      type: "menu",
      className: "tlui-menu__submenu__trigger",
      disabled,
      title,
      children: [
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiButtonLabel.TldrawUiButtonLabel, { children: label }),
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiButtonIcon.TldrawUiButtonIcon, { icon: "chevron-right", small: true })
      ]
    }
  ) });
}
function TldrawUiDropdownMenuSubContent({
  id,
  alignOffset = -1,
  sideOffset = -4,
  size = "small",
  children
}) {
  const container = (0, import_editor.useContainer)();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(_DropdownMenu.Portal, { container, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    _DropdownMenu.SubContent,
    {
      "data-testid": id,
      className: "tlui-menu tlui-menu__submenu__content",
      alignOffset,
      sideOffset,
      collisionPadding: 4,
      "data-size": size,
      children
    }
  ) });
}
function TldrawUiDropdownMenuGroup({ children }) {
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(_DropdownMenu.Group, { dir: "ltr", className: "tlui-menu__group", children });
}
function TldrawUiDropdownMenuIndicator() {
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(_DropdownMenu.ItemIndicator, { dir: "ltr", asChild: true, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiIcon.TldrawUiIcon, { icon: "check" }) });
}
function TldrawUiDropdownMenuItem({ noClose, children }) {
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(_DropdownMenu.Item, { dir: "ltr", asChild: true, onClick: noClose ? import_editor.preventDefault : void 0, children });
}
function TldrawUiDropdownMenuCheckboxItem({
  children,
  onSelect,
  ...rest
}) {
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
    _DropdownMenu.CheckboxItem,
    {
      dir: "ltr",
      className: "tlui-button tlui-button__menu tlui-button__checkbox",
      onSelect: (e) => {
        onSelect?.(e);
        (0, import_editor.preventDefault)(e);
      },
      ...rest,
      children: [
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tlui-button__checkbox__indicator", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(_DropdownMenu.ItemIndicator, { dir: "ltr", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiIcon.TldrawUiIcon, { icon: "check", small: true }) }) }),
        children
      ]
    }
  );
}
//# sourceMappingURL=TldrawUiDropdownMenu.js.map
