import { jsx, jsxs } from "react/jsx-runtime";
import React, { useEffect, useState } from "react";
import { TextArea } from "../text/TextArea.mjs";
import { TextHelpers } from "./TextHelpers.mjs";
import { isLegacyAlign } from "./legacyProps.mjs";
import { useEditableText } from "./useEditableText.mjs";
const TextLabel = React.memo(function TextLabel2({
  id,
  type,
  text,
  labelColor,
  font,
  fontSize,
  lineHeight,
  align,
  verticalAlign,
  wrap,
  isSelected,
  padding = 0,
  onKeyDown: handleKeyDownCustom,
  classNamePrefix,
  style,
  textWidth,
  textHeight
}) {
  const { rInput, isEmpty, isEditing, isEditingAnything, ...editableTextRest } = useEditableText(
    id,
    type,
    text
  );
  const [initialText, setInitialText] = useState(text);
  useEffect(() => {
    if (!isEditing) setInitialText(text);
  }, [isEditing, text]);
  const finalText = TextHelpers.normalizeTextForDom(text);
  const hasText = finalText.length > 0;
  const legacyAlign = isLegacyAlign(align);
  if (!isEditing && !hasText) {
    return null;
  }
  const cssPrefix = classNamePrefix || "tl-text";
  return /* @__PURE__ */ jsx(
    "div",
    {
      className: `${cssPrefix}-label tl-text-wrapper`,
      "data-font": font,
      "data-align": align,
      "data-hastext": !isEmpty,
      "data-isediting": isEditing,
      "data-iseditinganything": isEditingAnything,
      "data-textwrap": !!wrap,
      "data-isselected": isSelected,
      style: {
        justifyContent: align === "middle" || legacyAlign ? "center" : align,
        alignItems: verticalAlign === "middle" ? "center" : verticalAlign,
        padding,
        ...style
      },
      children: /* @__PURE__ */ jsxs(
        "div",
        {
          className: `${cssPrefix}-label__inner tl-text-content__wrapper`,
          style: {
            fontSize,
            lineHeight: Math.floor(fontSize * lineHeight) + "px",
            minHeight: Math.floor(fontSize * lineHeight) + "px",
            minWidth: Math.ceil(textWidth || 0),
            color: labelColor,
            width: textWidth ? Math.ceil(textWidth) : void 0,
            height: textHeight ? Math.ceil(textHeight) : void 0
          },
          children: [
            /* @__PURE__ */ jsx("div", { className: `${cssPrefix} tl-text tl-text-content`, dir: "auto", children: finalText.split("\n").map((lineOfText, index) => /* @__PURE__ */ jsx("div", { dir: "auto", children: lineOfText }, index)) }),
            (isEditingAnything || isSelected) && /* @__PURE__ */ jsx(
              TextArea,
              {
                ref: rInput,
                text,
                isEditing,
                ...editableTextRest,
                handleKeyDown: handleKeyDownCustom ?? editableTextRest.handleKeyDown
              },
              initialText
            )
          ]
        }
      )
    }
  );
});
export {
  TextLabel
};
//# sourceMappingURL=TextLabel.mjs.map
