import { useEditor, useValue } from "@tldraw/editor";
import { useEffect, useRef, useState } from "react";
function useAsset(shapeId, assetId, width) {
  const editor = useEditor();
  const [url, setUrl] = useState(null);
  const asset = assetId ? editor.getAsset(assetId) : null;
  const culledShapes = editor.getCulledShapes();
  const isCulled = culledShapes.has(shapeId);
  const didAlreadyResolve = useRef(false);
  useEffect(() => {
    if (url) didAlreadyResolve.current = true;
  }, [url]);
  const shapeScale = asset && "w" in asset.props ? width / asset.props.w : 1;
  const screenScale = useValue("zoom level", () => editor.getZoomLevel() * shapeScale, [
    editor,
    shapeScale
  ]);
  useEffect(() => {
    if (isCulled) return;
    let isCancelled = false;
    const timer = editor.timers.setTimeout(
      async () => {
        const resolvedUrl = await editor.resolveAssetUrl(assetId, {
          screenScale
        });
        if (!isCancelled) setUrl(resolvedUrl);
      },
      didAlreadyResolve.current ? 500 : 0
    );
    return () => {
      clearTimeout(timer);
      isCancelled = true;
    };
  }, [assetId, asset?.props.src, isCulled, screenScale, editor]);
  return { asset, url };
}
export {
  useAsset
};
//# sourceMappingURL=useAsset.mjs.map
