import { EASINGS, StateNode } from "@tldraw/editor";
import { Dragging } from "./childStates/Dragging.mjs";
import { Idle } from "./childStates/Idle.mjs";
import { Pointing } from "./childStates/Pointing.mjs";
class HandTool extends StateNode {
  static id = "hand";
  static initial = "idle";
  static isLockable = false;
  static children = () => [Idle, Pointing, Dragging];
  onDoubleClick = (info) => {
    if (info.phase === "settle") {
      const { currentScreenPoint } = this.editor.inputs;
      this.editor.zoomIn(currentScreenPoint, {
        animation: { duration: 220, easing: EASINGS.easeOutQuint }
      });
    }
  };
  onTripleClick = (info) => {
    if (info.phase === "settle") {
      const { currentScreenPoint } = this.editor.inputs;
      this.editor.zoomOut(currentScreenPoint, {
        animation: { duration: 320, easing: EASINGS.easeOutQuint }
      });
    }
  };
  onQuadrupleClick = (info) => {
    if (info.phase === "settle") {
      const zoomLevel = this.editor.getZoomLevel();
      const {
        inputs: { currentScreenPoint }
      } = this.editor;
      if (zoomLevel === 1) {
        this.editor.zoomToFit({ animation: { duration: 400, easing: EASINGS.easeOutQuint } });
      } else {
        this.editor.resetZoom(currentScreenPoint, {
          animation: { duration: 320, easing: EASINGS.easeOutQuint }
        });
      }
    }
  };
}
export {
  HandTool
};
//# sourceMappingURL=HandTool.mjs.map
