import { StateNode, Vec } from "@tldraw/editor";
class Dragging extends StateNode {
  static id = "dragging";
  initialCamera = new Vec();
  onEnter = () => {
    this.initialCamera = Vec.From(this.editor.getCamera());
    this.update();
  };
  onPointerMove = () => {
    this.update();
  };
  onPointerUp = () => {
    this.complete();
  };
  onCancel = () => {
    this.parent.transition("idle");
  };
  onComplete = () => {
    this.complete();
  };
  update() {
    const { initialCamera, editor } = this;
    const { currentScreenPoint, originScreenPoint } = editor.inputs;
    const delta = Vec.Sub(currentScreenPoint, originScreenPoint).div(editor.getZoomLevel());
    if (delta.len2() === 0) return;
    editor.setCamera(initialCamera.clone().add(delta));
  }
  complete() {
    const { editor } = this;
    const { pointerVelocity } = editor.inputs;
    const velocityAtPointerUp = Math.min(pointerVelocity.len(), 2);
    if (velocityAtPointerUp > 0.1) {
      this.editor.slideCamera({ speed: velocityAtPointerUp, direction: pointerVelocity });
    }
    this.parent.transition("idle");
  }
}
export {
  Dragging
};
//# sourceMappingURL=Dragging.mjs.map
