import { StateNode } from "@tldraw/editor";
class Lasering extends StateNode {
  static id = "lasering";
  scribbleId = "id";
  onEnter = () => {
    const scribble = this.editor.scribbles.addScribble({
      color: "laser",
      opacity: 0.7,
      size: 4,
      delay: 1200,
      shrink: 0.05,
      taper: true
    });
    this.scribbleId = scribble.id;
    this.pushPointToScribble();
  };
  onExit = () => {
    this.editor.scribbles.stop(this.scribbleId);
  };
  onPointerMove = () => {
    this.pushPointToScribble();
  };
  onPointerUp = () => {
    this.complete();
  };
  pushPointToScribble = () => {
    const { x, y } = this.editor.inputs.currentPagePoint;
    this.editor.scribbles.addPoint(this.scribbleId, x, y);
  };
  onCancel = () => {
    this.cancel();
  };
  onComplete = () => {
    this.complete();
  };
  complete() {
    this.parent.transition("idle");
  }
  cancel() {
    this.parent.transition("idle");
  }
}
export {
  Lasering
};
//# sourceMappingURL=Lasering.mjs.map
