import { StateNode } from "@tldraw/editor";
import { Cropping } from "./children/Cropping.mjs";
import { Idle } from "./children/Idle.mjs";
import { PointingCrop } from "./children/PointingCrop.mjs";
import { PointingCropHandle } from "./children/PointingCropHandle.mjs";
import { TranslatingCrop } from "./children/TranslatingCrop.mjs";
class Crop extends StateNode {
  static id = "crop";
  static initial = "idle";
  static children = () => [
    Idle,
    TranslatingCrop,
    PointingCrop,
    PointingCropHandle,
    Cropping
  ];
  markId = "";
  onEnter = () => {
    this.didCancel = false;
    this.markId = "crop";
    this.editor.mark(this.markId);
  };
  didCancel = false;
  onExit = () => {
    if (this.didCancel) {
      this.editor.bailToMark(this.markId);
    } else {
      this.editor.squashToMark(this.markId);
    }
  };
  onCancel = () => {
    this.didCancel = true;
  };
}
export {
  Crop
};
//# sourceMappingURL=Crop.mjs.map
