import { StateNode } from "@tldraw/editor";
import { CursorTypeMap } from "./PointingResizeHandle.mjs";
class PointingRotateHandle extends StateNode {
  static id = "pointing_rotate_handle";
  info = {};
  updateCursor() {
    this.editor.setCursor({
      type: CursorTypeMap[this.info.handle],
      rotation: this.editor.getSelectionRotation()
    });
  }
  onEnter = (info) => {
    this.parent.setCurrentToolIdMask(info.onInteractionEnd);
    this.info = info;
    this.updateCursor();
  };
  onExit = () => {
    this.parent.setCurrentToolIdMask(void 0);
    this.editor.setCursor({ type: "default", rotation: 0 });
  };
  onPointerMove = () => {
    if (this.editor.inputs.isDragging) {
      this.startRotating();
    }
  };
  onLongPress = () => {
    this.startRotating();
  };
  startRotating() {
    if (this.editor.getInstanceState().isReadonly) return;
    this.parent.transition("rotating", this.info);
  }
  onPointerUp = () => {
    this.complete();
  };
  onCancel = () => {
    this.cancel();
  };
  onComplete = () => {
    this.cancel();
  };
  onInterrupt = () => {
    this.cancel();
  };
  complete() {
    if (this.info.onInteractionEnd) {
      this.editor.setCurrentTool(this.info.onInteractionEnd, {});
    } else {
      this.parent.transition("idle");
    }
  }
  cancel() {
    if (this.info.onInteractionEnd) {
      this.editor.setCurrentTool(this.info.onInteractionEnd, {});
    } else {
      this.parent.transition("idle");
    }
  }
}
export {
  PointingRotateHandle
};
//# sourceMappingURL=PointingRotateHandle.mjs.map
