import { throttle } from "@tldraw/editor";
function _updateHoveredShapeId(editor) {
  const hitShape = editor.getShapeAtPoint(editor.inputs.currentPagePoint, {
    hitInside: false,
    hitLabels: false,
    margin: editor.options.hitTestMargin / editor.getZoomLevel(),
    renderingOnly: true
  });
  if (!hitShape) return editor.setHoveredShape(null);
  let shapeToHover = void 0;
  const outermostShape = editor.getOutermostSelectableShape(hitShape);
  if (outermostShape === hitShape) {
    shapeToHover = hitShape;
  } else {
    if (outermostShape.id === editor.getFocusedGroupId() || editor.getSelectedShapeIds().includes(outermostShape.id)) {
      shapeToHover = hitShape;
    } else {
      shapeToHover = outermostShape;
    }
  }
  return editor.setHoveredShape(shapeToHover.id);
}
const updateHoveredShapeId = throttle(
  _updateHoveredShapeId,
  process.env.NODE_ENV === "test" ? 0 : 32
);
export {
  updateHoveredShapeId
};
//# sourceMappingURL=updateHoveredShapeId.mjs.map
