import { jsx, jsxs } from "react/jsx-runtime";
import * as _ContextMenu from "@radix-ui/react-context-menu";
import { preventDefault, useContainer, useEditor, useEditorComponents } from "@tldraw/editor";
import { memo, useCallback } from "react";
import { useMenuIsOpen } from "../../hooks/useMenuIsOpen.mjs";
import { TldrawUiMenuContextProvider } from "../primitives/menus/TldrawUiMenuContext.mjs";
import { DefaultContextMenuContent } from "./DefaultContextMenuContent.mjs";
const DefaultContextMenu = memo(function DefaultContextMenu2({
  children
}) {
  const editor = useEditor();
  const { Canvas } = useEditorComponents();
  const cb = useCallback(
    (isOpen2) => {
      if (!isOpen2) {
        const onlySelectedShape = editor.getOnlySelectedShape();
        if (onlySelectedShape && editor.isShapeOrAncestorLocked(onlySelectedShape)) {
          editor.setSelectedShapes([]);
        }
      } else {
        if (editor.getInstanceState().isCoarsePointer) {
          const selectedShapes = editor.getSelectedShapes();
          const {
            inputs: { currentPagePoint }
          } = editor;
          const shapesAtPoint = editor.getShapesAtPoint(currentPagePoint);
          if (
            // if there are no selected shapes
            !editor.getSelectedShapes().length || // OR if none of the shapes at the point include the selected shape
            !shapesAtPoint.some((s) => selectedShapes.includes(s))
          ) {
            const lockedShapes = shapesAtPoint.filter((s) => editor.isShapeOrAncestorLocked(s));
            if (lockedShapes.length) {
              editor.select(...lockedShapes.map((s) => s.id));
            }
          }
        }
      }
    },
    [editor]
  );
  const container = useContainer();
  const [isOpen, handleOpenChange] = useMenuIsOpen("context menu", cb);
  const content = children ?? /* @__PURE__ */ jsx(DefaultContextMenuContent, {});
  return /* @__PURE__ */ jsxs(_ContextMenu.Root, { dir: "ltr", onOpenChange: handleOpenChange, modal: false, children: [
    /* @__PURE__ */ jsx(_ContextMenu.Trigger, { onContextMenu: void 0, dir: "ltr", children: Canvas ? /* @__PURE__ */ jsx(Canvas, {}) : null }),
    isOpen && /* @__PURE__ */ jsx(_ContextMenu.Portal, { container, children: /* @__PURE__ */ jsx(
      _ContextMenu.Content,
      {
        className: "tlui-menu scrollable",
        "data-testid": "context-menu",
        alignOffset: -4,
        collisionPadding: 4,
        onContextMenu: preventDefault,
        children: /* @__PURE__ */ jsx(TldrawUiMenuContextProvider, { type: "context-menu", sourceId: "context-menu", children: content })
      }
    ) })
  ] });
});
export {
  DefaultContextMenu
};
//# sourceMappingURL=DefaultContextMenu.mjs.map
