import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import { useActions } from "../../context/actions.mjs";
import { useShowCollaborationUi } from "../../hooks/useIsMultiplayer.mjs";
import { useTools } from "../../hooks/useTools.mjs";
import { TldrawUiMenuGroup } from "../primitives/menus/TldrawUiMenuGroup.mjs";
import { TldrawUiMenuItem } from "../primitives/menus/TldrawUiMenuItem.mjs";
function DefaultKeyboardShortcutsDialogContent() {
  const actions = useActions();
  const tools = useTools();
  const showCollaborationUi = useShowCollaborationUi();
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(TldrawUiMenuGroup, { label: "shortcuts-dialog.tools", id: "tools", children: [
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["toggle-tool-lock"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["insert-media"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...tools["select"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...tools["draw"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...tools["eraser"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...tools["hand"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...tools["rectangle"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...tools["ellipse"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...tools["arrow"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...tools["line"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...tools["text"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...tools["frame"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...tools["note"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...tools["laser"] })
    ] }),
    /* @__PURE__ */ jsxs(TldrawUiMenuGroup, { label: "shortcuts-dialog.preferences", id: "preferences", children: [
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["toggle-dark-mode"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["toggle-focus-mode"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["toggle-grid"] })
    ] }),
    /* @__PURE__ */ jsxs(TldrawUiMenuGroup, { label: "shortcuts-dialog.edit", id: "edit", children: [
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["undo"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["redo"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["cut"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["copy"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["paste"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["select-all"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["delete"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["duplicate"] })
    ] }),
    /* @__PURE__ */ jsxs(TldrawUiMenuGroup, { label: "shortcuts-dialog.view", id: "view", children: [
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["zoom-in"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["zoom-out"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["zoom-to-100"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["zoom-to-fit"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["zoom-to-selection"] })
    ] }),
    /* @__PURE__ */ jsxs(TldrawUiMenuGroup, { label: "shortcuts-dialog.transform", id: "transform", children: [
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["bring-to-front"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["bring-forward"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["send-backward"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["send-to-back"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["group"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["ungroup"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["flip-horizontal"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["flip-vertical"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["align-top"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["align-center-vertical"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["align-bottom"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["align-left"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["align-center-horizontal"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["align-right"] })
    ] }),
    showCollaborationUi && /* @__PURE__ */ jsx(TldrawUiMenuGroup, { label: "shortcuts-dialog.collaboration", id: "collaboration", children: /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["open-cursor-chat"] }) })
  ] });
}
export {
  DefaultKeyboardShortcutsDialogContent
};
//# sourceMappingURL=DefaultKeyboardShortcutsDialogContent.mjs.map
