import { jsx } from "react/jsx-runtime";
import { LANGUAGES, useEditor, useValue } from "@tldraw/editor";
import { useUiEvents } from "../context/events.mjs";
import { TldrawUiMenuCheckboxItem } from "./primitives/menus/TldrawUiMenuCheckboxItem.mjs";
import { TldrawUiMenuGroup } from "./primitives/menus/TldrawUiMenuGroup.mjs";
import { TldrawUiMenuSubmenu } from "./primitives/menus/TldrawUiMenuSubmenu.mjs";
function LanguageMenu() {
  const editor = useEditor();
  const trackEvent = useUiEvents();
  const currentLanguage = useValue("locale", () => editor.user.getLocale(), [editor]);
  return /* @__PURE__ */ jsx(TldrawUiMenuSubmenu, { id: "help menu language", label: "menu.language", children: /* @__PURE__ */ jsx(TldrawUiMenuGroup, { id: "languages", children: LANGUAGES.map(({ locale, label }) => /* @__PURE__ */ jsx(
    TldrawUiMenuCheckboxItem,
    {
      id: `language-${locale}`,
      title: locale,
      label,
      checked: locale === currentLanguage,
      onSelect: () => {
        editor.user.updateUserPreferences({ locale });
        trackEvent("change-language", { source: "menu", locale });
      }
    },
    locale
  )) }) });
}
export {
  LanguageMenu
};
//# sourceMappingURL=LanguageMenu.mjs.map
