import { jsx, jsxs } from "react/jsx-runtime";
import classNames from "classnames";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { TldrawUiIcon } from "../primitives/TldrawUiIcon.mjs";
function OfflineIndicator() {
  const msg = useTranslation();
  return /* @__PURE__ */ jsxs("div", { className: classNames("tlui-offline-indicator"), children: [
    msg("status.offline"),
    /* @__PURE__ */ jsx(TldrawUiIcon, { "aria-label": "offline", icon: "status-offline", small: true })
  ] });
}
export {
  OfflineIndicator
};
//# sourceMappingURL=OfflineIndicator.mjs.map
